/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.Config;
import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;

public abstract class ConfigProgram {
    public abstract void inject(Object var1, ConfigContext var2);

    public void addProgram(ConfigProgram program) {
        throw new UnsupportedOperationException("Cannot add a program to a BuilderProgram. You probably need a BuilderProgramContainer.");
    }

    public final void configure(Object bean) throws ConfigException {
        this.inject(bean, ConfigContext.create());
    }

    public final Object configure(Class type) throws ConfigException {
        return this.configure(type, ConfigContext.create());
    }

    protected final Object configure(Class type, ConfigContext env) throws ConfigException {
        try {
            Object bean = type.newInstance();
            this.inject(bean, env);
            return bean;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public final Object configure(ConfigType type) throws ConfigException {
        return this.configure(type, ConfigContext.create());
    }

    public Object configure(ConfigType type, ConfigContext env) throws ConfigException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void init(Object bean) throws ConfigException {
        Config.init(bean);
    }
}

