/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ValueGenerator;
import com.caucho.util.L10N;
import java.lang.reflect.Field;
import java.util.logging.Logger;
import javax.rmi.PortableRemoteObject;

public class FieldGeneratorProgram
extends ConfigProgram {
    private static final Logger log = Logger.getLogger(FieldGeneratorProgram.class.getName());
    private static final L10N L = new L10N(FieldGeneratorProgram.class);
    private Field _field;
    private ValueGenerator _gen;

    public FieldGeneratorProgram(Field field, ValueGenerator gen) {
        this._field = field;
        this._field.setAccessible(true);
        this._gen = gen;
    }

    String getName() {
        return this._field.getName();
    }

    Class getType() {
        return this._field.getType();
    }

    Class getDeclaringClass() {
        return this._field.getDeclaringClass();
    }

    public void inject(Object bean, ConfigContext env) throws ConfigException {
        try {
            Object value = this._gen.create();
            if (value != null && !this._field.getType().isAssignableFrom(value.getClass()) && !this._field.getType().isPrimitive()) {
                value = PortableRemoteObject.narrow((Object)value, this._field.getType());
            }
            this._field.set(bean, value);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((String)this.location(), (Throwable)e);
        }
    }

    private String location() {
        return this._field.getDeclaringClass().getName() + "." + this._field.getName() + ": ";
    }
}

