/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.webbeans.component.ComponentImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class MethodComponentProgram
extends ConfigProgram {
    private static final Logger log = Logger.getLogger(MethodComponentProgram.class.getName());
    private static final Object[] NULL_ARGS = new Object[0];
    private Method _method;
    private ComponentImpl[] _args;

    public MethodComponentProgram(Method method, ComponentImpl[] args) {
        this._method = method;
        this._method.setAccessible(true);
        this._args = args;
        if (this._method == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            throw new NullPointerException();
        }
    }

    public void inject(Object bean, ConfigContext env) throws ConfigException {
        try {
            Object[] args;
            if (this._args.length > 0) {
                args = new Object[this._args.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this._args[i].get(env);
                }
            } else {
                args = NULL_ARGS;
            }
            this._method.invoke(bean, args);
        }
        catch (InvocationTargetException e) {
            throw LineConfigException.create((String)this.loc(), (Throwable)e);
        }
        catch (Exception e) {
            throw LineConfigException.create((String)this.loc(), (Throwable)e);
        }
    }

    private String loc() {
        return this._method.getDeclaringClass().getSimpleName() + "." + this._method.getName() + ": ";
    }
}

