/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.program.NamedProgram;
import com.caucho.util.L10N;
import java.lang.reflect.Method;

public class MethodValueProgram
extends NamedProgram {
    private static final L10N L = new L10N(MethodValueProgram.class);
    private final Method _method;
    private final Object _value;

    public MethodValueProgram(Method method, Object value) {
        this._method = method;
        this._value = value;
        this._method.setAccessible(true);
    }

    public String getName() {
        return this._method.getName();
    }

    public void inject(Object bean, ConfigContext env) {
        try {
            this._method.invoke(bean, this._value);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(ConfigException.loc((Method)this._method) + L.l("Can't set method value '{0}'", this._value), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConfigException(ConfigException.loc((Method)this._method) + e.toString(), (Throwable)e);
        }
    }
}

