/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.util.L10N;
import com.caucho.xml.QName;

public class PropertyValueProgram
extends ConfigProgram {
    private static final L10N L = new L10N(PropertyValueProgram.class);
    private final String _name;
    private final QName _qName;
    private final Object _value;

    public PropertyValueProgram(String name, Object value) {
        this._name = name;
        this._qName = new QName(name);
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    public void inject(Object bean, ConfigContext env) {
        try {
            ConfigType type = TypeFactory.getType(bean.getClass());
            Attribute attr = type.getAttribute(this._qName);
            if (attr == null) {
                throw new ConfigException(L.l("'{0}' is an unknown attribute of '{1}'", (Object)this._qName.getName(), (Object)bean.getClass().getName()));
            }
            attr.setValue(bean, this._qName, attr.getConfigType().valueOf(this._value));
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }
}

