/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.ListType;
import com.caucho.config.type.TypeFactory;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ArrayType
extends ConfigType {
    private static final L10N L = new L10N(ArrayType.class);
    private static final Logger log = Logger.getLogger(ListType.class.getName());
    private final ConfigType _componentType;
    private final Class _componentClass;
    private final Class _type;

    public ArrayType(ConfigType componentType, Class componentClass) {
        this._componentType = componentType;
        this._componentClass = componentClass;
        Class<?> type = null;
        try {
            type = Array.newInstance(componentClass, 0).getClass();
        }
        catch (Exception e) {
            // empty catch block
        }
        this._type = type;
    }

    public Class getType() {
        return this._type;
    }

    public Object create(Object parent) {
        return new ArrayList();
    }

    public Attribute getAttribute(QName name) {
        return TypeFactory.getFactory().getListAttribute(name);
    }

    public Object replaceObject(Object value) {
        if (value == null) {
            return null;
        }
        List list = (List)value;
        Object[] array = (Object[])Array.newInstance(this._componentClass, list.size());
        list.toArray(array);
        return array;
    }

    public Object valueOf(String text) {
        throw new ConfigException(L.l("Can't convert to '{0}' from '{1}'.", (Object)this._type.getName(), (Object)text));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._componentClass.getName() + "]";
    }
}

