/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.DependencyBean;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.attribute.CreateAttribute;
import com.caucho.config.attribute.ProgramAttribute;
import com.caucho.config.attribute.PropertyAttribute;
import com.caucho.config.attribute.SetterAttribute;
import com.caucho.config.attribute.TextAttribute;
import com.caucho.config.j2ee.InjectIntrospector;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.PropertyStringProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.types.RawString;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.PersistentDependency;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class BeanType
extends ConfigType {
    private static final L10N L = new L10N(BeanType.class);
    private static final Logger log = Logger.getLogger(BeanType.class.getName());
    private static final QName TEXT = new QName("#text");
    private final Class _beanClass;
    private HashMap<QName, Attribute> _nsAttributeMap = new HashMap();
    private HashMap<String, Attribute> _attributeMap = new HashMap();
    private Constructor _stringConstructor;
    private Method _valueOf;
    private Method _setParent;
    private Method _replaceObject;
    private Method _setConfigLocation;
    private Attribute _addText;
    private Attribute _addProgram;
    private Attribute _setProperty;
    private ComponentImpl _component;
    private ArrayList<ConfigProgram> _injectList = new ArrayList();
    private ArrayList<ConfigProgram> _initList = new ArrayList();

    public BeanType(Class beanClass) {
        this._beanClass = beanClass;
    }

    public Class getType() {
        return this._beanClass;
    }

    public Object create(Object parent) {
        try {
            if (this._component == null) {
                if (this._beanClass.isInterface()) {
                    throw new ConfigException(L.l("{0} cannot be instantiated because it is an interface", (Object)this._beanClass.getName()));
                }
                WebBeansContainer webBeans = WebBeansContainer.create(this._beanClass.getClassLoader());
                this._component = (ComponentImpl)webBeans.createTransient(this._beanClass);
            }
            Object bean = this._component.createNoInit();
            if (this._setParent != null && parent != null && this._setParent.getParameterTypes()[0].isAssignableFrom(parent.getClass())) {
                try {
                    this._setParent.invoke(bean, parent);
                }
                catch (IllegalArgumentException e) {
                    throw ConfigException.create((Method)this._setParent, (String)L.l("{0}: setParent value of '{1}' is not valid", bean, parent), (Throwable)e);
                }
                catch (Exception e) {
                    throw ConfigException.create((Method)this._setParent, (Throwable)e);
                }
            }
            return bean;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void beforeConfigure(ConfigContext env, Object bean, Node node) {
        super.beforeConfigure(env, bean, node);
        if (this._setConfigLocation != null && node instanceof QNode) {
            String filename = ((QNode)node).getFilename();
            int line = ((QNode)node).getLine();
            try {
                this._setConfigLocation.invoke(bean, filename, line);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        if (bean instanceof DependencyBean) {
            DependencyBean dependencyBean = (DependencyBean)bean;
            ArrayList<Dependency> dependencyList = env.getDependencyList();
            if (dependencyList != null) {
                for (Dependency depend : dependencyList) {
                    dependencyBean.addDependency((PersistentDependency)depend);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getAttribute(QName name) {
        HashMap<QName, Attribute> hashMap = this._nsAttributeMap;
        synchronized (hashMap) {
            Attribute attr = this._nsAttributeMap.get(name);
            if (attr == null && (attr = this._attributeMap.get(name.getLocalName())) != null) {
                this._nsAttributeMap.put(name, attr);
            }
            if (attr != null) {
                return attr;
            }
        }
        return null;
    }

    public Attribute getProgramAttribute() {
        if (this._setProperty != null) {
            return this._setProperty;
        }
        return this._addProgram;
    }

    public void inject(Object bean) {
        for (int i = 0; i < this._injectList.size(); ++i) {
            this._injectList.get(i).inject(bean, null);
        }
    }

    public void init(Object bean) {
        for (int i = 0; i < this._initList.size(); ++i) {
            this._initList.get(i).inject(bean, null);
        }
    }

    public Object replaceObject(Object bean) {
        if (this._replaceObject != null) {
            try {
                return this._replaceObject.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw ConfigException.create((Method)this._replaceObject, (Throwable)e);
            }
        }
        return bean;
    }

    public Object valueOf(String text) {
        if (this._valueOf != null) {
            try {
                return this._valueOf.invoke(null, text);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        if (this._stringConstructor != null) {
            try {
                return this._stringConstructor.newInstance(text);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        if (this._addText != null) {
            Object bean = this.create(null);
            this._addText.setText(bean, TEXT, text);
            this.inject(bean);
            this.init(bean);
            return bean;
        }
        if (this._addProgram != null) {
            Object bean = this.create(null);
            this.inject(bean);
            try {
                PropertyStringProgram program = new PropertyStringProgram("value", text);
                this._addProgram.setValue(bean, TEXT, program);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            this.init(bean);
            return bean;
        }
        throw new ConfigException(L.l("Can't convert to '{0}' from '{1}'.", (Object)this._beanClass.getName(), (Object)text));
    }

    public Object valueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (this._beanClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value.getClass().getName().startsWith("java.lang.")) {
            return this.valueOf(String.valueOf(value));
        }
        return value;
    }

    public void introspect() {
        this.introspectMethods();
        InjectIntrospector.introspectInject(this._injectList, this._beanClass);
        InjectIntrospector.introspectInit(this._initList, this._beanClass);
    }

    public void introspectMethods() {
        try {
            Method valueOf = this._beanClass.getMethod("valueOf", String.class);
            if (Modifier.isStatic(valueOf.getModifiers())) {
                this._valueOf = valueOf;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            this._stringConstructor = this._beanClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            Method replaceObject;
            this._replaceObject = replaceObject = this._beanClass.getMethod("replaceObject", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        for (Method method : this._beanClass.getMethods()) {
            Attribute attr;
            ConfigType type;
            if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            String name = method.getName();
            if ((name.equals("addBuilderProgram") || name.equals("addProgram")) && paramTypes.length == 1 && paramTypes[0].equals(ConfigProgram.class)) {
                type = TypeFactory.getType(paramTypes[0]);
                this._addProgram = new ProgramAttribute(method, type);
                continue;
            }
            if (name.equals("setConfigLocation") && paramTypes.length == 2 && paramTypes[0].equals(String.class) && paramTypes[1].equals(Integer.TYPE)) {
                this._setConfigLocation = method;
                continue;
            }
            if (name.equals("setProperty") && paramTypes.length == 2 && paramTypes[0].equals(String.class)) {
                type = TypeFactory.getType(paramTypes[1]);
                PropertyAttribute attr2 = new PropertyAttribute(method, type);
                this._setProperty = attr2;
                continue;
            }
            if (name.equals("setParent") && paramTypes.length == 1) {
                this._setParent = method;
                continue;
            }
            if ((name.startsWith("set") || name.startsWith("add")) && paramTypes.length == 1 && this.findCreate(name.substring(3)) == null) {
                type = TypeFactory.getType(paramTypes[0]);
                String propName = this.toXmlName(name.substring(3));
                if (propName.equals("text") && (paramTypes[0].equals(String.class) || paramTypes[0].equals(RawString.class))) {
                    attr = new TextAttribute(method, type);
                    this._addText = attr;
                    this._attributeMap.put("#text", attr);
                } else {
                    attr = new SetterAttribute(method, type);
                }
                this._attributeMap.put(propName, attr);
                if (propName.equals("value")) {
                    this._attributeMap.put("#text", attr);
                    if (this._addText == null) {
                        this._addText = attr;
                    }
                }
                propName = this.toCamelName(name.substring(3));
                this._attributeMap.put(propName, attr);
                continue;
            }
            if (!name.startsWith("create") || paramTypes.length != 0 || Void.TYPE.equals(method.getReturnType())) continue;
            type = TypeFactory.getType(method.getReturnType());
            Method setter = this.findSetter(name.substring(6));
            attr = new CreateAttribute(method, type, setter);
            String propName = this.toXmlName(name.substring(6));
            this._attributeMap.put(propName, attr);
        }
    }

    private Method findCreate(String name) {
        String createName = "create" + name;
        for (Method method : this._beanClass.getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.getName().equals(createName)) continue;
            return method;
        }
        return null;
    }

    private Method findSetter(String name) {
        String addName = "add" + name;
        String setName = "set" + name;
        for (Method method : this._beanClass.getMethods()) {
            if (method.getParameterTypes().length != 1 || !method.getName().equals(addName) && !method.getName().equals(setName)) continue;
            return method;
        }
        return null;
    }

    private String toXmlName(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch) && i > 0 && (Character.isLowerCase(name.charAt(i - 1)) || i + 1 < name.length() && Character.isLowerCase(name.charAt(i + 1)))) {
                sb.append('-');
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }

    private String toCamelName(String name) {
        return Introspector.decapitalize(name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._beanClass.getName() + "]";
    }
}

