/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;
import java.util.HashMap;

public final class EnumType
extends ConfigType {
    private static final L10N L = new L10N(EnumType.class);
    private Class _type;
    private HashMap<String, Object> _nameMap = new HashMap();

    public EnumType(Class type) {
        this._type = type;
        for (Object value : type.getEnumConstants()) {
            Enum enumValue = (Enum)value;
            String name = enumValue.name();
            this._nameMap.put(name, enumValue);
        }
    }

    public Class getType() {
        return this._type;
    }

    public Object valueOf(String text) {
        if (text == null) {
            return null;
        }
        Object value = this._nameMap.get(text);
        if (value != null) {
            return value;
        }
        throw new ConfigException(L.l("{0}: '{1}' is an unknown enumeration value.", (Object)this._type.getName(), (Object)text));
    }

    public Object valueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (this._type.isAssignableFrom(value.getClass())) {
            return value;
        }
        return this.valueOf(String.valueOf(value));
    }
}

