/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.attribute.EntryAttribute;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Modifier;
import java.util.TreeMap;
import java.util.logging.Logger;

public class MapType
extends ConfigType {
    private static final L10N L = new L10N(MapType.class);
    private static final Logger log = Logger.getLogger(MapType.class.getName());
    private final Class _mapClass;
    private final Class _instanceClass;
    private final EntryAttribute _entryAttribute;

    public MapType() {
        this(TreeMap.class);
    }

    public MapType(Class mapClass) {
        this._mapClass = mapClass;
        this._instanceClass = !this._mapClass.isInterface() && Modifier.isAbstract(this._mapClass.getModifiers()) ? this._mapClass : TreeMap.class;
        this._entryAttribute = new EntryAttribute();
    }

    public Class getType() {
        return this._mapClass;
    }

    public Object create(Object parent) {
        try {
            return this._instanceClass.newInstance();
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public Attribute getAttribute(QName name) {
        return this._entryAttribute;
    }

    public Object valueOf(String text) {
        throw new ConfigException(L.l("Can't convert to '{0}' from '{1}'.", (Object)this._mapClass.getName(), (Object)text));
    }
}

