/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.type.TypeFactory;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.WbComponentConfig;

public class BeanConfig
extends WbComponentConfig {
    private static final L10N L = new L10N(BeanConfig.class);
    private String _filename;
    private int _line;
    private String _uri;
    private String _jndiName;
    private String _mbeanName;
    private Class _mbeanClass;
    private Class _beanConfigClass;

    public BeanConfig() {
        if (this.getDefaultScope() != null) {
            this.setScope(this.getDefaultScope());
        }
    }

    protected String getDefaultScope() {
        return "singleton";
    }

    public void setConfigLocation(String filename, int line) {
        this._filename = filename;
        this._line = line;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
        if (this.getName() == null) {
            this.setName(jndiName);
        }
    }

    public void setMbeanName(String mbeanName) {
        this._mbeanName = mbeanName;
    }

    public String getMBeanName() {
        return this._mbeanName;
    }

    public void setMbeanClass(Class cl) {
        this.setMbeanInterface(cl);
    }

    public void setMbeanInterface(Class cl) {
        this._mbeanClass = cl;
    }

    public Class getBeanConfigClass() {
        return this._beanConfigClass;
    }

    public void setBeanConfigClass(Class cl) {
        this._beanConfigClass = cl;
    }

    public void setType(Class cl) {
        this.setClass(cl);
    }

    public void setClass(Class cl) {
        super.setClass(cl);
        Class type = this.getBeanConfigClass();
        if (type != null && !type.isAssignableFrom(cl)) {
            throw new ConfigException(L.l("'{0}' is not a valid instance of '{1}'", (Object)cl.getName(), (Object)type.getName()));
        }
    }

    public void setUri(String uri) {
        String[] props;
        String scheme;
        Class beanConfigClass = this.getBeanConfigClass();
        if (beanConfigClass == null) {
            throw new ConfigException(L.l("'{0}' does not support the 'uri' attribute because its bean-config-class is undefined", (Object)this.getClass().getName()));
        }
        this._uri = uri;
        String properties = "";
        int p = uri.indexOf(58);
        if (p >= 0) {
            scheme = uri.substring(0, p);
            properties = uri.substring(p + 1);
        } else {
            scheme = uri;
        }
        TypeFactory factory = TypeFactory.create();
        this.setClass(factory.getDriverClassByUrl(beanConfigClass, uri));
        for (String prop : props = properties.split("[;]")) {
            if (prop.length() == 0) continue;
            String[] values = prop.split("[=]");
            if (values.length != 2) {
                throw new ConfigException(L.l("'{0}' is an invalid URI.  Bean URI syntax is 'scheme:prop1=value1;prop2=value2'", (Object)uri));
            }
            this.addStringProperty(values[0], values[1]);
        }
    }

    public String getUri() {
        return this._uri;
    }

    public void init() {
        super.init();
        try {
            if (this._comp != null && this._jndiName != null) {
                Jndi.bindDeepShort(this._jndiName, this._comp);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    protected void introspectPostInit() {
    }
}

