/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.types.BaseRef;
import com.caucho.config.types.EjbRefContext;
import com.caucho.config.types.InjectionTarget;
import com.caucho.ejb.AbstractServer;
import com.caucho.naming.Jndi;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.component.ObjectProxyComponent;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.reflect.Type;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.webbeans.Standard;

public class EjbRef
extends BaseRef
implements ObjectProxy {
    private static final L10N L = new L10N(EjbRef.class);
    private static final Logger log = Logger.getLogger(EjbRef.class.getName());
    private String _loc;
    private Context _context;
    private String _ejbRefName;
    private String _type;
    private Class _home;
    private Class _remote;
    private String _foreignName;
    private String _ejbLink;
    private String _typeName;
    private Object _target;
    private boolean _isInitBinding;
    private String _clientClassName;

    public EjbRef() {
    }

    public EjbRef(Context context) {
        this._context = context;
    }

    public EjbRef(Path modulePath) {
        super(modulePath);
    }

    public EjbRef(Path modulePath, String sourceEjbName) {
        super(modulePath, sourceEjbName);
    }

    public void setConfigLocation(String loc) {
        this._loc = loc;
    }

    public boolean isEjbLocalRef() {
        return false;
    }

    public InjectionTarget getInjectionTarget() {
        return this._injectionTarget;
    }

    public Class getLocal() {
        return null;
    }

    protected String getTagName() {
        return "<ejb-ref>";
    }

    public void setId(String id) {
    }

    public void setDescription(String description) {
    }

    public void setClientClassName(String clientClassName) {
        this._clientClassName = clientClassName;
    }

    public void setEjbRefName(String name) {
        this._ejbRefName = name;
    }

    public void setInjectionTarget(InjectionTarget injectionTarget) {
        this._injectionTarget = injectionTarget;
    }

    public String getEjbRefName() {
        return this._ejbRefName;
    }

    public void setEjbRefType(String type) {
        this._type = type;
    }

    public void setHome(Class home) {
        this._home = home;
    }

    public Class getHome() {
        return this._home;
    }

    public void setRemote(Class remote) {
        this._remote = remote;
    }

    public Class getRemote() {
        return this._remote;
    }

    public void setForeignName(String foreignName) {
        this._foreignName = foreignName;
    }

    public void setEjbLink(String ejbLink) {
        this._ejbLink = ejbLink;
    }

    public void mergeFrom(EjbRef other) {
        if (this._foreignName == null) {
            this._foreignName = other._foreignName;
        }
        if (this._ejbLink == null) {
            this._ejbLink = other._ejbLink;
        }
        if (this._type == null) {
            this._type = other._type;
        }
        if (this._home == null) {
            this._home = other._home;
        }
        if (this._remote == null) {
            this._remote = other._remote;
        }
        if (this._injectionTarget == null) {
            this._injectionTarget = other._injectionTarget;
        }
    }

    @PostConstruct
    public void init() throws Exception {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, L.l("{0} init", (Object)this));
        }
    }

    public void bind() throws Exception {
        this.initBinding(null);
    }

    public void initBinding(AbstractServer ejbServer) throws Exception {
        int pos;
        if (this._isInitBinding) {
            return;
        }
        this._isInitBinding = true;
        if (this._foreignName != null && (pos = this._foreignName.indexOf("#")) < 0 && this._home == null) {
            if (this._remote != null) {
                this._foreignName = this._foreignName + "#" + this._remote.getName().replace(".", "_");
            } else if (this.getLocal() != null) {
                this._foreignName = this._foreignName + "#" + this.getLocal().getName().replace(".", "_");
            }
        }
        EjbRefContext context = EjbRefContext.createLocal();
        context.add(this);
        WebBeansContainer webBeans = WebBeansContainer.create();
        ComponentImpl comp = null;
        if (this._home != null) {
            if (comp == null && this._ejbLink != null) {
                comp = webBeans.bind(this._loc, (Type)this._home, this._ejbLink);
            }
            if (comp == null) {
                comp = webBeans.bind(this._loc, (Type)this._home, this._ejbRefName);
            }
            if (comp == null) {
                comp = webBeans.bind(this._loc, this._home);
            }
            if (comp == null) {
                comp = new ObjectProxyComponent(webBeans, this, this._home);
                comp.setName(this._ejbRefName);
                comp.addNameBinding(this._ejbRefName);
                comp.setType(webBeans.createComponentType(Standard.class));
                webBeans.addComponent(comp);
            }
        } else if (this._remote != null) {
            if (comp == null && this._ejbLink != null) {
                comp = webBeans.bind(this._loc, (Type)this._home, this._ejbLink);
            }
            if (comp == null) {
                comp = webBeans.bind(this._loc, (Type)this._remote, this._ejbRefName);
            }
            if (comp == null) {
                comp = webBeans.bind(this._loc, this._remote);
            }
            if (comp == null) {
                comp = new ObjectProxyComponent(webBeans, this, this._remote);
                comp.setName(this._ejbRefName);
                comp.addNameBinding(this._ejbRefName);
                comp.setType(webBeans.createComponentType(Standard.class));
                webBeans.addComponent(comp);
            }
        }
        String fullEjbRefName = Jndi.getFullName(this._ejbRefName);
        boolean bind = false;
        if (bind) {
            Jndi.rebindDeep(fullEjbRefName, this);
        }
    }

    public Object createObject(Hashtable env) throws NamingException {
        if (this._target == null) {
            if (this._foreignName != null) {
                this.resolve(null);
            } else if (this._home != null) {
                this.resolve(this._home);
            } else if (this._remote != null) {
                this.resolve(this._remote);
            } else if (this.getLocal() != null) {
                this.resolve(this.getLocal());
            } else {
                this.resolve(null);
            }
        }
        return this._target;
    }

    public Object getByType(Class type) {
        try {
            if (this._home != null && type.isAssignableFrom(this._home)) {
                return this.createObject(null);
            }
            if (this._remote != null && type.isAssignableFrom(this._remote)) {
                return this.createObject(null);
            }
            if (this._foreignName != null) {
                int pos = this._foreignName.indexOf("#");
                if (pos > 0) {
                    String intf = this._foreignName.substring(++pos).replace("_", ".");
                    if (!type.getName().equals(intf)) {
                        return null;
                    }
                }
                String foreignName = this._foreignName.replace('.', '_');
                Object target = this._context != null ? this._context.lookup(foreignName) : Jndi.lookup(foreignName);
                if (target != null && type != null) {
                    return PortableRemoteObject.narrow((Object)target, (Class)type);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void resolve(Class type) throws NamingException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, L.l("{0} resolving", (Object)this));
        }
        this._target = this._foreignName != null ? this.lookupByForeignJndi(this._foreignName, type) : (this._ejbLink != null ? this.lookupByLink(this._ejbLink, type) : this.lookupLocal(type));
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, L.l("{0} resolved", (Object)this));
        }
    }

    private Object lookupByLink(String link, Class type) throws NamingException {
        String archiveName;
        Object target = null;
        int hashIndex = link.indexOf(35);
        if (hashIndex < 0) {
            archiveName = null;
            String ejbName = link;
        } else {
            archiveName = link.substring(0, hashIndex);
            String ejbName = link.substring(hashIndex + 1);
        }
        try {
            Path path = archiveName == null ? this._modulePath : this._modulePath.lookup(archiveName);
            throw new IllegalStateException();
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            throw new NamingException(L.l("{0} '{1}'  ejb-link '{2}' invalid ", (Object)this.getTagName(), (Object)this._ejbRefName, (Object)link));
        }
    }

    private Object lookupByForeignJndi(String foreignName, Class type) throws NamingException {
        Object target = Jndi.lookup(foreignName);
        return target;
    }

    private Object lookupLocal(Class type) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ejbRefName + ", " + this._ejbLink + ", " + this._foreignName + "]";
    }
}

