/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.types.ResourceGroupConfig;
import com.caucho.config.types.Validator;
import com.caucho.el.Expr;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EnvEntry
extends ResourceGroupConfig
implements Validator {
    private static final L10N L = new L10N(EnvEntry.class);
    private static final Logger log = Logger.getLogger(EnvEntry.class.getName());
    private String _name;
    private Class _type;
    private String _value;
    private Object _objValue;

    public void setId(String id) {
    }

    public void setEnvEntryName(String name) {
        this._name = name;
    }

    public String getEnvEntryName() {
        return this._name;
    }

    public void setEnvEntryType(Class type) {
        this._type = type;
    }

    public Class getEnvEntryType() {
        return this._type;
    }

    public void setEnvEntryValue(String value) {
        this._value = value;
    }

    public String getEnvEntryValue() {
        return this._value;
    }

    @PostConstruct
    public void init() throws Exception {
        if (this._name == null) {
            throw new ConfigException(L.l("env-entry needs 'env-entry-name' attribute"));
        }
        if (this._type == null) {
            throw new ConfigException(L.l("env-entry needs 'env-entry-type' attribute"));
        }
        super.init();
        if (this._value == null) {
            return;
        }
        Object value = this._value;
        if (!this._type.equals(String.class)) {
            if (this._type.equals(Boolean.class)) {
                value = new Boolean(Expr.toBoolean(this._value, null));
            } else if (this._type.equals(Byte.class)) {
                value = new Byte((byte)Expr.toLong(this._value, null));
            } else if (this._type.equals(Short.class)) {
                value = new Short((short)Expr.toLong(this._value, null));
            } else if (this._type.equals(Integer.class)) {
                value = new Integer((int)Expr.toLong(this._value, null));
            } else if (this._type.equals(Long.class)) {
                value = new Long(Expr.toLong(this._value, null));
            } else if (this._type.equals(Float.class)) {
                value = new Float((float)Expr.toDouble(this._value, null));
            } else if (this._type.equals(Double.class)) {
                value = new Double(Expr.toDouble(this._value, null));
            } else if (this._type.equals(Character.class)) {
                String v = Expr.toString(this._value, null);
                value = v == null || v.length() == 0 ? null : new Character(v.charAt(0));
            }
        }
        this._objValue = value;
        WebBeansContainer webBeans = WebBeansContainer.create();
        webBeans.addSingleton(value, this._name);
        Jndi.bindDeepShort(this._name, value);
    }

    public void validate() throws ConfigException {
        Object obj = null;
        try {
            obj = new InitialContext().lookup("java:comp/env/" + this._name);
        }
        catch (NamingException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (obj == null) {
            throw this.error(L.l("env-entry '{0}' was not configured.  All resources defined by <env-entry> tags must be defined in a configuration file.", (Object)this._name));
        }
    }

    public String toString() {
        return "EnvEntry[" + this._name + "]";
    }
}

