/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.types.BeanConfig;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.util.logging.Logger;

public class InterfaceConfig
extends BeanConfig {
    private static final Logger log = Logger.getLogger(InterfaceConfig.class.getName());
    private static final L10N L = new L10N(InterfaceConfig.class);
    private boolean _isDeploy;
    private boolean _isFactory = true;
    private String _tagName = "bean";
    private String _valueName;
    private Object _value;

    public InterfaceConfig() {
    }

    public InterfaceConfig(Class type) {
        this.setBeanConfigClass(type);
    }

    public InterfaceConfig(Class type, String tagName) {
        this.setBeanConfigClass(type);
        this.setTagName(tagName);
    }

    protected String getDefaultScope() {
        return null;
    }

    public void setType(Class cl) {
        this.setClass(cl);
    }

    public void setClass(Class cl) {
        super.setClass(cl);
        if (!this.getBeanConfigClass().isAssignableFrom(cl)) {
            throw new ConfigException(L.l("instance class '{0}' must implement '{1}'", (Object)cl.getName(), (Object)this.getBeanConfigClass().getName()));
        }
    }

    public void setDeploy(boolean isDeploy) {
        this._isDeploy = isDeploy;
        if (this._isDeploy) {
            this.setScope("singleton");
        }
    }

    public void setFactory(boolean isFactory) {
        this._isFactory = isFactory;
    }

    public void setTagName(String tagName) {
        this._tagName = tagName;
    }

    public String getTagName() {
        return this._tagName;
    }

    public void setName(String name) {
        super.setName(name);
        this.setDeploy(true);
    }

    public void setJndiName(String name) {
        super.setJndiName(name);
        this.setDeploy(true);
    }

    public void setValue(String value) {
        this._valueName = value;
    }

    public void init() {
        if (this._valueName != null) {
            WebBeansContainer webBeans = WebBeansContainer.create();
            this._comp = webBeans.findByName(this._valueName);
            if (this._comp == null) {
                this._value = Jndi.lookup(this._valueName);
            }
            if (this._comp == null && this._value == null) {
                throw new ConfigException(L.l("'{0}' is an unknown bean", (Object)this._valueName));
            }
        } else if (this.getClassType() != null) {
            super.init();
        }
    }

    public void deploy() {
        if (this._isDeploy) {
            super.deploy();
        }
    }

    public Object getObject() {
        if (this._value != null) {
            return this._value;
        }
        if (this.getClassType() != null) {
            return super.getObject();
        }
        if (this.getBeanConfigClass().isAssignableFrom(String.class)) {
            return this._valueName;
        }
        return null;
    }

    public Object createObjectNoInit() {
        if (this._value != null) {
            return this._value;
        }
        if (this.getClassType() != null) {
            return super.createObjectNoInit();
        }
        if (this.getBeanConfigClass().isAssignableFrom(String.class)) {
            return this._valueName;
        }
        return null;
    }

    public Object replaceObject() {
        if (this._isFactory) {
            return this.getObject();
        }
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getBeanConfigClass().getName() + "]";
    }
}

