/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.amber.manager.AmberContainer;
import com.caucho.config.types.EjbRef;
import com.caucho.naming.Jndi;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.L10N;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class PersistenceUnitRef
implements ObjectProxy {
    private static final L10N L = new L10N(EjbRef.class);
    private static final Logger log = Logger.getLogger(EjbRef.class.getName());
    private String _location = "";
    private String _persistenceUnitRefName;
    private String _persistenceUnitName;
    private String _mappedName;
    private EntityManagerFactory _emf;

    public void setConfigLocation(String location) {
        this._location = location;
    }

    protected String getTagName() {
        return "<persistence-unit-ref>";
    }

    public void setId(String id) {
    }

    public void setDescription(String description) {
    }

    public void setDisplayName(String displayName) {
    }

    public void setPersistenceUnitRefName(String name) {
        this._persistenceUnitRefName = name;
    }

    public String getPersistenceUnitRefName() {
        return this._persistenceUnitRefName;
    }

    public void setPersistenceUnitName(String name) {
        this._persistenceUnitName = name;
    }

    public String getPersistenceUnitName() {
        return this._persistenceUnitName;
    }

    public void setMappedName(String name) {
        this._mappedName = name;
    }

    public String getMappedName() {
        return this._mappedName;
    }

    @PostConstruct
    public void init() throws Exception {
        block11: {
            if (this._persistenceUnitRefName == null) {
                return;
            }
            if (this._persistenceUnitName == null) {
                this._persistenceUnitName = "default";
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(L.l("adding persistence unit ref: {0}", (Object)this._persistenceUnitRefName));
            }
            String fullJndiName = Jndi.getFullName(this._persistenceUnitRefName);
            try {
                Object oldValue = new InitialContext().lookup(fullJndiName);
                if (oldValue != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(L.l("persistence unit ref {0} exists. returning.", (Object)this._persistenceUnitRefName));
                    }
                    return;
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(L.l("look up persistence unit {0}", (Object)this._persistenceUnitName));
            }
            try {
                Object obj = new InitialContext().lookup(AmberContainer.getPersistenceUnitJndiPrefix() + this._persistenceUnitName);
                if (log.isLoggable(Level.FINER)) {
                    log.finer(L.l("binding persistence-unit-ref {0} to persistence unit {1}", (Object)this._persistenceUnitRefName, (Object)this._persistenceUnitName));
                }
                Jndi.rebindDeep(fullJndiName, obj);
            }
            catch (NamingException e) {
                if (!log.isLoggable(Level.FINER)) break block11;
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    public Object createObject(Hashtable env) throws NamingException {
        if (this._emf == null) {
            this._emf = Persistence.createEntityManagerFactory((String)this._persistenceUnitName);
            if (this._emf == null) {
                log.warning(L.l(this._location + "'{0}' is an unknown persistence-unit-name", (Object)this._persistenceUnitName));
            }
        }
        return this._emf;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._persistenceUnitName + "]";
    }
}

