/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.InjectionTarget;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public abstract class ResourceGroupConfig
extends ConfigProgram {
    private static final L10N L = new L10N(ResourceGroupConfig.class);
    private static final Logger log = Logger.getLogger(ResourceGroupConfig.class.getName());
    private String _location = "";
    private String _description;
    private String _defaultInjectionClass;
    private ArrayList<InjectionTarget> _injectionTargets = new ArrayList();

    public void setDefaultInjectionClass(String className) {
        this._defaultInjectionClass = className;
    }

    public void setId(String id) {
    }

    public void setConfigLocation(String filename, int line) {
        this._location = filename + ":" + line + " ";
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void addInjectionTarget(InjectionTarget injectionTarget) {
        this._injectionTargets.add(injectionTarget);
    }

    @PostConstruct
    public void init() throws Exception {
        for (InjectionTarget injectionTarget : this._injectionTargets) {
        }
    }

    public void inject(Object bean, ConfigContext env) {
    }

    protected ConfigException error(String msg) {
        if (this._location != null) {
            return new LineConfigException(this._location + msg);
        }
        return new ConfigException(msg);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._location + "]";
    }
}

