/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.InjectionTarget;
import com.caucho.config.types.Validator;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.naming.Jndi;
import com.caucho.sql.DBPool;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ResourceRef
implements Validator {
    private static Logger log = Logger.getLogger(ResourceRef.class.getName());
    private static L10N L = new L10N(ResourceRef.class);
    private String _location = "";
    private String _name;
    private Class _type;
    private String _description;
    private boolean _sharing;
    private ConfigProgram _init;
    private HashMap<String, String> _params = new HashMap();
    private InjectionTarget _injectionTarget;

    public void setId(String id) {
    }

    public void setConfigLocation(String filename, int line) {
        this._location = filename + ":" + line + " ";
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setInjectionTarget(InjectionTarget injectionTarget) {
        this._injectionTarget = injectionTarget;
    }

    public void setResRefName(String name) {
        this._name = name;
    }

    public String getResRefName() {
        return this._name;
    }

    public void setResType(Class type) {
        this._type = type;
    }

    public void setResAuth(String auth) {
    }

    public void setResSharingScope(String share) {
    }

    public void setClassName(Class type) {
        this._type = type;
    }

    public InjectionTarget getInjectionTarget() {
        return this._injectionTarget;
    }

    public Class getResType() {
        return this._type;
    }

    public void setInit(ConfigProgram init) {
        this._init = init;
    }

    public ConfigProgram getInit() {
        return this._init;
    }

    public void setInitParam(InitParam initParam) {
        this._params.putAll(initParam.getParameters());
    }

    @PostConstruct
    public void init() throws Throwable {
        if (this._init == null && this._params.size() == 0) {
            return;
        }
        Class<DBPool> cl = this._type;
        if (DataSource.class.equals((Object)this._type)) {
            cl = DBPool.class;
        }
        Object obj = cl.newInstance();
        if (this._init != null) {
            this._init.configure(obj);
        }
        for (String key : this._params.keySet()) {
            String value = this._params.get(key);
            Config.setAttribute(obj, key, value);
        }
        if (obj instanceof ClassLoaderListener) {
            ClassLoaderListener listener = (ClassLoaderListener)obj;
            for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
                if (!(loader instanceof EnvironmentClassLoader)) continue;
                ((DynamicClassLoader)loader).addListener(listener);
                break;
            }
        }
        Jndi.bindDeep(this._name, obj);
    }

    public void validate() throws ConfigException {
        Object obj = null;
        try {
            obj = new InitialContext().lookup("java:comp/env/" + this._name);
        }
        catch (NamingException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        if (obj == null) {
            throw this.error(L.l("resource-ref '{0}' was not configured.  All resources defined by <resource-ref> tags must be defined in a configuration file.", (Object)this._name));
        }
    }

    public ConfigException error(String msg) {
        if (this._location != null) {
            return new LineConfigException(this._location + msg);
        }
        return new ConfigException(msg);
    }

    public String toString() {
        return "ResourceRef[" + this._name + "]";
    }
}

