/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

public class Signature {
    private static L10N L = new L10N(Signature.class);
    private String _signature;
    private String _className;
    private String _name;
    private String[] _parameterTypes;
    private String _returnType;
    private int _index;

    public Signature() {
    }

    public Signature(String sig) {
        this.addText(sig);
        this.init();
    }

    public String getSignature() {
        return this._signature;
    }

    public String getName() {
        return this._name;
    }

    public String getClassName() {
        return this._className;
    }

    public Method getMethod() {
        if (this._className == null) {
            return null;
        }
        try {
            Class cl = CauchoSystem.loadClass(this._className);
            if (cl == null) {
                return null;
            }
            Method[] methods = cl.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!this.matches(methods[i])) continue;
                return methods[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getReturnType() {
        return this._returnType;
    }

    public String[] getParameterTypes() {
        return this._parameterTypes;
    }

    public void addText(String value) {
        this._signature = value;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._signature != null) {
            this.parseSignature();
        }
    }

    public boolean matches(Method method) {
        String[] sigTypes;
        if (!method.getName().equals(this.getName())) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != (sigTypes = this.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            String param = this.getName(parameterTypes[i]);
            if (param.equals(sigTypes[i]) || param.endsWith("." + sigTypes[i])) continue;
            return false;
        }
        return true;
    }

    private String getName(Class cl) {
        if (cl.isArray()) {
            return this.getName(cl.getComponentType()) + "[]";
        }
        return cl.getName();
    }

    private void parseSignature() throws ConfigException {
        this._index = 0;
        this._returnType = this.parseType(this.skipWhitespace(this.read()));
        CharBuffer cb = CharBuffer.allocate();
        int ch = this.skipWhitespace(this.read());
        if (ch == 40 || ch < 0) {
            this._name = this._returnType;
            this._returnType = null;
        } else {
            while (Character.isJavaIdentifierPart((char)ch) || ch == 46) {
                cb.append((char)ch);
                ch = this.read();
            }
            if (cb.length() == 0) {
                throw new ConfigException(L.l("unexpected empty function name in `{0}'", (Object)this._signature));
            }
            this._name = cb.toString();
            int p = this._name.lastIndexOf(46);
            if (p > 0) {
                this._className = this._name.substring(0, p);
                this._name = this._name.substring(p + 1);
            }
            ch = this.skipWhitespace(ch);
        }
        if (ch != 40) {
            throw new ConfigException(L.l("function syntax is `ret-type name(arg1, ..., argn)' in `{0}'", (Object)this._signature));
        }
        ArrayList<String> argList = new ArrayList<String>();
        ch = this.read();
        while (Character.isJavaIdentifierPart((char)(ch = this.skipWhitespace(ch))) || ch == 46) {
            String type = this.parseType(ch);
            argList.add(type);
            ch = this.skipWhitespace(this.read());
            while (Character.isJavaIdentifierPart((char)ch) || ch == 46) {
                ch = this.read();
            }
            if (ch != 44) continue;
            ch = this.read();
        }
        this._parameterTypes = argList.toArray(new String[argList.size()]);
        if (ch != 41) {
            throw new ConfigException(L.l("function syntax is `ret-type name(arg1, ..., argn)' in `{0}'", (Object)this._signature));
        }
        ch = this.skipWhitespace(this.read());
        if (ch != -1) {
            throw new ConfigException(L.l("function syntax is `ret-type name(arg1, ..., argn)' in `{0}'", (Object)this._signature));
        }
    }

    private String parseType(int ch) throws ConfigException {
        CharBuffer cb = CharBuffer.allocate();
        while (Character.isJavaIdentifierPart((char)ch) || ch == 46) {
            cb.append((char)ch);
            ch = this.read();
        }
        if (cb.length() == 0) {
            throw new ConfigException(L.l("unexpected empty type in `{0}'", (Object)this._signature));
        }
        while (true) {
            if (Character.isWhitespace((char)ch)) {
                ch = this.read();
                continue;
            }
            if (ch != 91) break;
            ch = this.read();
            if (ch != 93) {
                throw new ConfigException(L.l("function syntax is `ret-type name(arg1, ..., argn)' in `{0}'", (Object)this._signature));
            }
            cb.append("[]");
            ch = this.read();
        }
        String className = cb.toString();
        this.unread(ch);
        return className;
    }

    private int skipWhitespace(int ch) {
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        return ch;
    }

    private int read() {
        if (this._index < this._signature.length()) {
            return this._signature.charAt(this._index++);
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._index;
        }
    }

    public String toString() {
        return "Signature[" + this._signature + "]";
    }
}

