/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.index;

import com.caucho.db.Database;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.index.StringKeyCompare;
import com.caucho.db.store.Block;
import com.caucho.db.store.BlockManager;
import com.caucho.db.store.Lock;
import com.caucho.db.store.Store;
import com.caucho.db.store.Transaction;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BTree {
    private static final L10N L = new L10N(BTree.class);
    private static final Logger log = Log.open(BTree.class);
    public static final long FAIL = 0L;
    private static final int BLOCK_SIZE = 65536;
    private static final int PTR_SIZE = 8;
    private static final int FLAGS_OFFSET = 0;
    private static final int LENGTH_OFFSET = 4;
    private static final int PARENT_OFFSET = 8;
    private static final int NEXT_OFFSET = 16;
    private static final int HEADER_SIZE = 24;
    private static final int LEAF_FLAG = 1;
    private BlockManager _blockManager;
    private final Lock _lock;
    private Store _store;
    private long _rootBlockId;
    private Block _rootBlock;
    private int _keySize;
    private int _tupleSize;
    private int _n;
    private int _minN;
    private KeyCompare _keyCompare;
    private int _blockCount;
    private volatile boolean _isStarted;

    public BTree(Store store, long rootBlockId, int keySize, KeyCompare keyCompare) throws IOException {
        if (keyCompare == null) {
            throw new NullPointerException();
        }
        this._store = store;
        this._blockManager = this._store.getBlockManager();
        this._rootBlockId = rootBlockId;
        this._rootBlock = store.readBlock(rootBlockId);
        this._lock = new Lock("index:" + store.getName());
        if (65536 < keySize + 24) {
            throw new IOException(L.l("BTree key size `{0}' is too large.", (long)keySize));
        }
        this._keySize = keySize;
        this._tupleSize = keySize + 8;
        this._n = 65512 / this._tupleSize;
        this._minN = (this._n + 1) / 2;
        if (this._minN < 0) {
            this._minN = 1;
        }
        this._keyCompare = keyCompare;
    }

    public long getIndexRoot() {
        return this._rootBlockId;
    }

    public void create() throws IOException {
    }

    public long lookup(byte[] keyBuffer, int keyOffset, int keyLength, Transaction xa) throws IOException, SQLException {
        return this.lookup(keyBuffer, keyOffset, keyLength, xa, this._rootBlockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long lookup(byte[] keyBuffer, int keyOffset, int keyLength, Transaction xa, long blockId) throws IOException, SQLException {
        Block block;
        if (blockId == this._rootBlockId) {
            block = this._rootBlock;
            block.allocate();
        } else {
            block = this._store.readBlock(blockId);
        }
        try {
            long value;
            Lock blockLock;
            block7: {
                long l;
                blockLock = block.getLock();
                xa.lockRead(blockLock);
                try {
                    byte[] buffer = block.getBuffer();
                    boolean isLeaf = this.isLeaf(buffer);
                    value = this.lookupTuple(blockId, buffer, keyBuffer, keyOffset, keyLength, isLeaf);
                    if (!isLeaf && value != 0L) break block7;
                    l = value;
                    Object var16_13 = null;
                }
                catch (Throwable throwable) {
                    Object var16_15 = null;
                    xa.unlockRead(blockLock);
                    throw throwable;
                }
                xa.unlockRead(blockLock);
                Object var18_16 = null;
                block.free();
                return l;
            }
            long l = this.lookup(keyBuffer, keyOffset, keyLength, xa, value);
            Object var16_14 = null;
            xa.unlockRead(blockLock);
            Object var18_17 = null;
            block.free();
            return l;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            block.free();
            throw throwable;
        }
    }

    public void insert(byte[] keyBuffer, int keyOffset, int keyLength, long value, Transaction xa, boolean isOverride) throws SQLException {
        try {
            while (!this.insert(keyBuffer, keyOffset, keyLength, value, xa, isOverride, this._rootBlockId)) {
                this.splitRoot(this._rootBlockId, xa);
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            throw new SQLExceptionWrapper(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insert(byte[] keyBuffer, int keyOffset, int keyLength, long value, Transaction xa, boolean isOverride, long blockId) throws IOException, SQLException {
        Block block;
        if (blockId == this._rootBlockId) {
            block = this._rootBlock;
            block.allocate();
        } else {
            block = this._store.readBlock(blockId);
        }
        try {
            boolean bl;
            byte[] buffer;
            Lock blockLock;
            block10: {
                block9: {
                    blockLock = block.getLock();
                    xa.lockRead(blockLock);
                    buffer = block.getBuffer();
                    int length = this.getLength(buffer);
                    if (length != this._n) break block9;
                    boolean bl2 = false;
                    Object var18_15 = null;
                    xa.unlockRead(blockLock);
                    Object var20_19 = null;
                    block.free();
                    return bl2;
                }
                if (!this.isLeaf(buffer)) break block10;
                this.insertValue(keyBuffer, keyOffset, keyLength, value, xa, isOverride, block);
                boolean bl3 = true;
                Object var18_16 = null;
                xa.unlockRead(blockLock);
                Object var20_20 = null;
                block.free();
                return bl3;
            }
            try {
                long childBlockId = this.lookupTuple(blockId, buffer, keyBuffer, keyOffset, keyLength, false);
                while (!this.insert(keyBuffer, keyOffset, keyLength, value, xa, isOverride, childBlockId)) {
                    this.split(block, childBlockId, xa);
                    childBlockId = this.lookupTuple(blockId, buffer, keyBuffer, keyOffset, keyLength, false);
                }
                bl = true;
                Object var18_17 = null;
            }
            catch (Throwable throwable) {
                Object var18_18 = null;
                xa.unlockRead(blockLock);
                throw throwable;
            }
            xa.unlockRead(blockLock);
            Object var20_21 = null;
            block.free();
            return bl;
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertValue(byte[] keyBuffer, int keyOffset, int keyLength, long value, Transaction xa, boolean isOverride, Block block) throws IOException, SQLException {
        byte[] buffer = block.getBuffer();
        Lock blockLock = block.getLock();
        xa.lockWrite(blockLock);
        try {
            block.setFlushDirtyOnCommit(false);
            block.setDirty(0, 65536);
            this.insertLeafBlock(block.getBlockId(), buffer, keyBuffer, keyOffset, keyLength, value, isOverride);
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            xa.unlockWrite(blockLock);
            throw throwable;
        }
        xa.unlockWrite(blockLock);
    }

    private long insertLeafBlock(long blockId, byte[] buffer, byte[] keyBuffer, int keyOffset, int keyLength, long value, boolean isOverride) throws IOException, SQLException {
        int offset = 24;
        int tupleSize = this._tupleSize;
        int length = this.getLength(buffer);
        for (int i = 0; i < length; ++i) {
            int cmp = this._keyCompare.compare(keyBuffer, keyOffset, buffer, offset + 8, keyLength);
            if (0 < cmp) {
                offset += tupleSize;
                continue;
            }
            if (cmp == 0) {
                long oldValue;
                if (!isOverride && value != (oldValue = this.getPointer(buffer, offset))) {
                    throw new SQLException(L.l("'{0}' insert of key '{1}' fails index uniqueness.", (Object)this._store, (Object)this._keyCompare.toString(keyBuffer, keyOffset, keyLength)));
                }
                this.setPointer(buffer, offset, value);
                return 0L;
            }
            if (length < this._n) {
                return this.addKey(blockId, buffer, offset, i, length, keyBuffer, keyOffset, keyLength, value);
            }
            throw new IllegalStateException("ran out of key space");
        }
        if (length < this._n) {
            return this.addKey(blockId, buffer, offset, length, length, keyBuffer, keyOffset, keyLength, value);
        }
        throw new IllegalStateException();
    }

    private long addKey(long blockId, byte[] buffer, int offset, int index, int length, byte[] keyBuffer, int keyOffset, int keyLength, long value) throws IOException {
        int tupleSize = this._tupleSize;
        if (index < length) {
            if (offset + tupleSize < 24) {
                throw new IllegalStateException();
            }
            System.arraycopy(buffer, offset, buffer, offset + tupleSize, (length - index) * tupleSize);
        }
        this.setPointer(buffer, offset, value);
        this.setLength(buffer, length + 1);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("btree insert at " + this.debugId(blockId) + ":" + offset + " value:" + this.debugId(value));
        }
        if (offset + 8 < 24) {
            throw new IllegalStateException();
        }
        System.arraycopy(keyBuffer, keyOffset, buffer, offset + 8, keyLength);
        for (int j = 8 + keyLength; j < tupleSize; ++j) {
            buffer[offset + j] = 0;
        }
        return -value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void split(Block parent, long blockId, Transaction xa) throws IOException, SQLException {
        Lock parentLock = parent.getLock();
        xa.lockWrite(parentLock);
        try {
            Block block = this._store.readBlock(blockId);
            try {
                Lock blockLock = block.getLock();
                xa.lockReadAndWrite(blockLock);
                try {
                    this.split(parent, block, xa);
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    xa.unlockReadAndWrite(blockLock);
                    throw throwable;
                }
                xa.unlockReadAndWrite(blockLock);
                Object var11_10 = null;
                block.free();
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                block.free();
                throw throwable;
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            xa.unlockWrite(parentLock);
            throw throwable;
        }
        xa.unlockWrite(parentLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void split(Block parentBlock, Block block, Transaction xa) throws IOException, SQLException {
        long parentId = parentBlock.getBlockId();
        long blockId = block.getBlockId();
        log.finer("btree splitting " + this.debugId(blockId));
        block.setFlushDirtyOnCommit(false);
        block.setDirty(0, 65536);
        byte[] buffer = block.getBuffer();
        int length = this.getLength(buffer);
        if (length < this._n / 2) {
            return;
        }
        if (length < 2) {
            throw new IllegalStateException(L.l("illegal length '{0}' for block {1}", (Object)length, (Object)this.debugId(blockId)));
        }
        Block leftBlock = null;
        try {
            parentBlock.setFlushDirtyOnCommit(false);
            parentBlock.setDirty(0, 65536);
            byte[] parentBuffer = parentBlock.getBuffer();
            int parentLength = this.getLength(parentBuffer);
            leftBlock = this._store.allocateIndexBlock();
            leftBlock.setFlushDirtyOnCommit(false);
            leftBlock.setDirty(0, 65536);
            byte[] leftBuffer = leftBlock.getBuffer();
            long leftBlockId = leftBlock.getBlockId();
            int pivot = length / 2;
            int pivotSize = pivot * this._tupleSize;
            int pivotEnd = 24 + pivotSize;
            int blockEnd = 24 + length * this._tupleSize;
            System.arraycopy(buffer, 24, leftBuffer, 24, pivotSize);
            this.setInt(leftBuffer, 0, this.getInt(buffer, 0));
            this.setLength(leftBuffer, pivot);
            this.setPointer(leftBuffer, 16, 0L);
            this.setPointer(leftBuffer, 8, parentId);
            System.arraycopy(buffer, pivotEnd, buffer, 24, blockEnd - pivotEnd);
            this.setLength(buffer, length - pivot);
            this.insertLeafBlock(parentId, parentBuffer, leftBuffer, pivotEnd - this._tupleSize + 8, this._keySize, leftBlockId, true);
            Object var21_17 = null;
            if (leftBlock != null) {
                leftBlock.free();
            }
        }
        catch (Throwable throwable) {
            Object var21_18 = null;
            if (leftBlock != null) {
                leftBlock.free();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitRoot(long rootBlockId, Transaction xa) throws IOException, SQLException {
        Block rootBlock = this._rootBlock;
        rootBlock.allocate();
        try {
            Lock rootLock = rootBlock.getLock();
            xa.lockReadAndWrite(rootLock);
            try {
                this.splitRoot(rootBlock, xa);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                xa.unlockReadAndWrite(rootLock);
                throw throwable;
            }
            xa.unlockReadAndWrite(rootLock);
            Object var9_8 = null;
            rootBlock.free();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            rootBlock.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitRoot(Block parentBlock, Transaction xa) throws IOException {
        long parentId = parentBlock.getBlockId();
        log.finer("btree splitting root " + parentId / 65536L);
        Block leftBlock = null;
        Block rightBlock = null;
        try {
            parentBlock.setFlushDirtyOnCommit(false);
            parentBlock.setDirty(0, 65536);
            byte[] parentBuffer = parentBlock.getBuffer();
            int parentFlags = this.getInt(parentBuffer, 0);
            leftBlock = this._store.allocateIndexBlock();
            leftBlock.setFlushDirtyOnCommit(false);
            leftBlock.setDirty(0, 65536);
            long leftBlockId = leftBlock.getBlockId();
            rightBlock = this._store.allocateIndexBlock();
            rightBlock.setFlushDirtyOnCommit(false);
            rightBlock.setDirty(0, 65536);
            long rightBlockId = rightBlock.getBlockId();
            int length = this.getLength(parentBuffer);
            int pivot = (length - 1) / 2;
            if (length <= 2 || this._n < length || pivot < 1 || length <= pivot) {
                throw new IllegalStateException(length + " is an illegal length, or pivot " + pivot + " is bad, with n=" + this._n);
            }
            int pivotOffset = 24 + pivot * this._tupleSize;
            long pivotValue = this.getPointer(parentBuffer, pivotOffset);
            byte[] leftBuffer = leftBlock.getBuffer();
            System.arraycopy(parentBuffer, 24, leftBuffer, 24, pivotOffset + this._tupleSize - 24);
            this.setInt(leftBuffer, 0, parentFlags);
            this.setLength(leftBuffer, pivot + 1);
            this.setPointer(leftBuffer, 8, parentId);
            this.setPointer(leftBuffer, 16, rightBlockId);
            byte[] rightBuffer = rightBlock.getBuffer();
            if (length - pivot - 1 < 0) {
                throw new IllegalStateException("illegal length " + pivot + " " + length);
            }
            System.arraycopy(parentBuffer, pivotOffset + this._tupleSize, rightBuffer, 24, (length - pivot - 1) * this._tupleSize);
            this.setInt(rightBuffer, 0, parentFlags);
            this.setLength(rightBuffer, length - pivot - 1);
            this.setPointer(rightBuffer, 8, parentId);
            this.setPointer(rightBuffer, 16, this.getPointer(parentBuffer, 16));
            System.arraycopy(parentBuffer, pivotOffset, parentBuffer, 24, this._tupleSize);
            this.setPointer(parentBuffer, 24, leftBlockId);
            this.setInt(parentBuffer, 0, 1);
            this.setLength(parentBuffer, 1);
            this.setPointer(parentBuffer, 16, rightBlockId);
            Object var21_16 = null;
            if (leftBlock != null) {
                leftBlock.free();
            }
            if (rightBlock != null) {
                rightBlock.free();
            }
        }
        catch (Throwable throwable) {
            Object var21_17 = null;
            if (leftBlock != null) {
                leftBlock.free();
            }
            if (rightBlock != null) {
                rightBlock.free();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte[] keyBuffer, int keyOffset, int keyLength, Transaction xa) throws SQLException {
        try {
            Block rootBlock = this._rootBlock;
            rootBlock.allocate();
            try {
                Lock rootLock = rootBlock.getLock();
                xa.lockRead(rootLock);
                try {
                    this.remove(rootBlock, keyBuffer, keyOffset, keyLength, xa);
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    xa.unlockRead(rootLock);
                    throw throwable;
                }
                xa.unlockRead(rootLock);
                Object var10_11 = null;
                rootBlock.free();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                rootBlock.free();
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Block block, byte[] keyBuffer, int keyOffset, int keyLength, Transaction xa) throws IOException, SQLException {
        byte[] buffer;
        block9: {
            buffer = block.getBuffer();
            long blockId = block.getBlockId();
            boolean isLeaf = this.isLeaf(buffer);
            if (isLeaf) {
                Lock blockLock = block.getLock();
                xa.lockWrite(blockLock);
                try {
                    block.setFlushDirtyOnCommit(false);
                    block.setDirty(0, 65536);
                    this.removeLeafEntry(blockId, buffer, keyBuffer, keyOffset, keyLength);
                    Object var12_11 = null;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    xa.unlockWrite(blockLock);
                    throw throwable;
                }
                xa.unlockWrite(blockLock);
                {
                    break block9;
                }
            }
            long childId = this.lookupTuple(blockId, buffer, keyBuffer, keyOffset, keyLength, isLeaf);
            if (childId == 0L) {
                return true;
            }
            Block childBlock = this._store.readBlock(childId);
            try {
                boolean isJoin = false;
                Lock childLock = childBlock.getLock();
                xa.lockRead(childLock);
                try {
                    isJoin = !this.remove(childBlock, keyBuffer, keyOffset, keyLength, xa);
                    Object var16_17 = null;
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    xa.unlockRead(childLock);
                    throw throwable;
                }
                xa.unlockRead(childLock);
                if (isJoin && this.joinBlocks(block, childBlock, xa)) {
                    xa.deallocateBlock(childBlock);
                }
                Object var18_20 = null;
                childBlock.free();
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                childBlock.free();
                throw throwable;
            }
        }
        return this._minN <= this.getLength(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean joinBlocks(Block parent, Block block, Transaction xa) throws IOException, SQLException {
        boolean bl;
        byte[] parentBuffer = parent.getBuffer();
        int parentLength = this.getLength(parentBuffer);
        long blockId = block.getBlockId();
        byte[] buffer = block.getBuffer();
        Lock parentLock = parent.getLock();
        xa.lockWrite(parentLock);
        try {
            Lock blockLock;
            byte[] rightBuffer;
            Block rightBlock2;
            int leftLength;
            Lock leftLock;
            byte[] leftBuffer;
            Block leftBlock;
            long leftBlockId = this.getLeftBlockId(parent, blockId);
            long rightBlockId = this.getRightBlockId(parent, blockId);
            if (leftBlockId > 0L) {
                leftBlock = this._store.readBlock(leftBlockId);
                try {
                    leftBuffer = leftBlock.getBuffer();
                    leftLock = leftBlock.getLock();
                    xa.lockReadAndWrite(leftLock);
                    try {
                        Lock blockLock2;
                        block43: {
                            boolean bl2;
                            leftLength = this.getLength(leftBuffer);
                            blockLock2 = block.getLock();
                            xa.lockReadAndWrite(blockLock2);
                            try {
                                if (this._minN >= leftLength || this.isLeaf(buffer) != this.isLeaf(leftBuffer)) break block43;
                                parent.setFlushDirtyOnCommit(false);
                                parent.setDirty(0, 65536);
                                leftBlock.setFlushDirtyOnCommit(false);
                                leftBlock.setDirty(0, 65536);
                                this.moveFromLeft(parentBuffer, leftBuffer, buffer, blockId);
                                bl2 = false;
                                Object var21_26 = null;
                            }
                            catch (Throwable throwable) {
                                Object var21_28 = null;
                                xa.unlockReadAndWrite(blockLock2);
                                throw throwable;
                            }
                            xa.unlockReadAndWrite(blockLock2);
                            Object var23_29 = null;
                            xa.unlockReadAndWrite(leftLock);
                            Object var25_32 = null;
                            leftBlock.free();
                            Object var45_35 = null;
                            xa.unlockWrite(parentLock);
                            return bl2;
                        }
                        Object var21_27 = null;
                        xa.unlockReadAndWrite(blockLock2);
                        Object var23_30 = null;
                        xa.unlockReadAndWrite(leftLock);
                    }
                    catch (Throwable throwable) {
                        Object var23_31 = null;
                        xa.unlockReadAndWrite(leftLock);
                        throw throwable;
                    }
                    Object var25_33 = null;
                    leftBlock.free();
                }
                catch (Throwable throwable) {
                    Object var25_34 = null;
                    leftBlock.free();
                    throw throwable;
                }
            }
            if (rightBlockId > 0L) {
                rightBlock2 = this._store.readBlock(rightBlockId);
                try {
                    rightBuffer = rightBlock2.getBuffer();
                    blockLock = block.getLock();
                    xa.lockReadAndWrite(blockLock);
                    try {
                        Lock rightLock;
                        block44: {
                            boolean bl3;
                            rightLock = rightBlock2.getLock();
                            xa.lockReadAndWrite(rightLock);
                            try {
                                int rightLength = this.getLength(rightBuffer);
                                if (this._minN >= rightLength || this.isLeaf(buffer) != this.isLeaf(rightBuffer)) break block44;
                                parent.setFlushDirtyOnCommit(false);
                                parent.setDirty(0, 65536);
                                rightBlock2.setFlushDirtyOnCommit(false);
                                rightBlock2.setDirty(0, 65536);
                                this.moveFromRight(parentBuffer, buffer, rightBuffer, blockId);
                                bl3 = false;
                                Object var27_47 = null;
                            }
                            catch (Throwable throwable) {
                                Object var27_49 = null;
                                xa.unlockReadAndWrite(rightLock);
                                throw throwable;
                            }
                            xa.unlockReadAndWrite(rightLock);
                            Object var29_50 = null;
                            xa.unlockReadAndWrite(blockLock);
                            Object var31_53 = null;
                            rightBlock2.free();
                            Object var45_36 = null;
                            xa.unlockWrite(parentLock);
                            return bl3;
                        }
                        Object var27_48 = null;
                        xa.unlockReadAndWrite(rightLock);
                        Object var29_51 = null;
                        xa.unlockReadAndWrite(blockLock);
                    }
                    catch (Throwable throwable) {
                        Object var29_52 = null;
                        xa.unlockReadAndWrite(blockLock);
                        throw throwable;
                    }
                    Object var31_54 = null;
                    rightBlock2.free();
                }
                catch (Throwable throwable) {
                    Object var31_55 = null;
                    rightBlock2.free();
                    throw throwable;
                }
            }
            if (parentLength < 2) {
                boolean rightBlock2 = false;
                Object var45_37 = null;
                xa.unlockWrite(parentLock);
                return rightBlock2;
            }
            if (leftBlockId > 0L) {
                leftBlock = this._store.readBlock(leftBlockId);
                try {
                    leftBuffer = leftBlock.getBuffer();
                    leftLock = leftBlock.getLock();
                    xa.lockReadAndWrite(leftLock);
                    try {
                        Lock blockLock3;
                        block45: {
                            boolean bl4;
                            leftLength = this.getLength(leftBuffer);
                            blockLock3 = block.getLock();
                            xa.lockReadAndWrite(blockLock3);
                            try {
                                int length = this.getLength(buffer);
                                if (this.isLeaf(leftBuffer) != this.isLeaf(buffer) || length + leftLength > this._n) break block45;
                                parent.setFlushDirtyOnCommit(false);
                                parent.setDirty(0, 65536);
                                leftBlock.setFlushDirtyOnCommit(false);
                                leftBlock.setDirty(0, 65536);
                                this.mergeLeft(parentBuffer, leftBuffer, buffer, blockId);
                                bl4 = true;
                                Object var33_59 = null;
                            }
                            catch (Throwable throwable) {
                                Object var33_61 = null;
                                xa.unlockReadAndWrite(blockLock3);
                                throw throwable;
                            }
                            xa.unlockReadAndWrite(blockLock3);
                            Object var35_62 = null;
                            xa.unlockReadAndWrite(leftLock);
                            Object var37_65 = null;
                            leftBlock.free();
                            Object var45_38 = null;
                            xa.unlockWrite(parentLock);
                            return bl4;
                        }
                        Object var33_60 = null;
                        xa.unlockReadAndWrite(blockLock3);
                        Object var35_63 = null;
                        xa.unlockReadAndWrite(leftLock);
                    }
                    catch (Throwable throwable) {
                        Object var35_64 = null;
                        xa.unlockReadAndWrite(leftLock);
                        throw throwable;
                    }
                    Object var37_66 = null;
                    leftBlock.free();
                }
                catch (Throwable throwable) {
                    Object var37_67 = null;
                    leftBlock.free();
                    throw throwable;
                }
            }
            if (rightBlockId > 0L) {
                rightBlock2 = this._store.readBlock(rightBlockId);
                try {
                    rightBuffer = rightBlock2.getBuffer();
                    blockLock = block.getLock();
                    xa.lockReadAndWrite(blockLock);
                    try {
                        Lock rightLock;
                        block46: {
                            boolean bl5;
                            rightLock = rightBlock2.getLock();
                            xa.lockReadAndWrite(rightLock);
                            try {
                                int length = this.getLength(buffer);
                                int rightLength = this.getLength(rightBuffer);
                                if (this.isLeaf(rightBuffer) != this.isLeaf(buffer) || length + rightLength > this._n) break block46;
                                rightBlock2.setFlushDirtyOnCommit(false);
                                rightBlock2.setDirty(0, 65536);
                                parent.setFlushDirtyOnCommit(false);
                                parent.setDirty(0, 65536);
                                this.mergeRight(parentBuffer, buffer, rightBuffer, blockId);
                                bl5 = true;
                                Object var39_71 = null;
                            }
                            catch (Throwable throwable) {
                                Object var39_73 = null;
                                xa.unlockReadAndWrite(rightLock);
                                throw throwable;
                            }
                            xa.unlockReadAndWrite(rightLock);
                            Object var41_74 = null;
                            xa.unlockReadAndWrite(blockLock);
                            Object var43_77 = null;
                            rightBlock2.free();
                            Object var45_39 = null;
                            xa.unlockWrite(parentLock);
                            return bl5;
                        }
                        Object var39_72 = null;
                        xa.unlockReadAndWrite(rightLock);
                        Object var41_75 = null;
                        xa.unlockReadAndWrite(blockLock);
                    }
                    catch (Throwable throwable) {
                        Object var41_76 = null;
                        xa.unlockReadAndWrite(blockLock);
                        throw throwable;
                    }
                    Object var43_78 = null;
                    rightBlock2.free();
                }
                catch (Throwable throwable) {
                    Object var43_79 = null;
                    rightBlock2.free();
                    throw throwable;
                }
            }
            bl = false;
            Object var45_40 = null;
        }
        catch (Throwable throwable) {
            Object var45_41 = null;
            xa.unlockWrite(parentLock);
            throw throwable;
        }
        xa.unlockWrite(parentLock);
        return bl;
    }

    private long getLeftBlockId(Block parent, long blockId) {
        long pointer;
        int offset;
        byte[] buffer = parent.getBuffer();
        int length = this.getLength(buffer);
        if (length < 1) {
            throw new IllegalStateException("zero length for " + this.debugId(parent.getBlockId()));
        }
        int tupleSize = this._tupleSize;
        int end = offset + length * tupleSize;
        for (offset = 24; offset < end; offset += tupleSize) {
            pointer = this.getPointer(buffer, offset);
            if (pointer != blockId) continue;
            if (24 < offset) {
                return this.getPointer(buffer, offset - tupleSize);
            }
            return -1L;
        }
        pointer = this.getPointer(buffer, 16);
        if (pointer == blockId) {
            return this.getPointer(buffer, 24 + (length - 1) * tupleSize);
        }
        throw new IllegalStateException("Can't find " + this.debugId(blockId) + " in parent " + this.debugId(parent.getBlockId()));
    }

    private void moveFromLeft(byte[] parentBuffer, byte[] leftBuffer, byte[] buffer, long blockId) {
        int parentLength = this.getLength(parentBuffer);
        int tupleSize = this._tupleSize;
        int parentOffset = 24;
        int parentEnd = parentOffset + parentLength * tupleSize;
        int leftLength = this.getLength(leftBuffer);
        int length = this.getLength(buffer);
        int parentLeftOffset = -1;
        if (blockId == this.getPointer(parentBuffer, 16)) {
            parentLeftOffset = parentEnd - tupleSize;
        } else {
            parentOffset += tupleSize;
            while (parentOffset < parentEnd) {
                long pointer = this.getPointer(parentBuffer, parentOffset);
                if (pointer == blockId) {
                    parentLeftOffset = parentOffset - tupleSize;
                    break;
                }
                parentOffset += tupleSize;
            }
        }
        if (parentLeftOffset < 0) {
            log.warning("Can't find parent left in deletion borrow left ");
            return;
        }
        System.arraycopy(buffer, 24, buffer, 24 + tupleSize, length * tupleSize);
        System.arraycopy(leftBuffer, 24 + (leftLength - 1) * tupleSize, buffer, 24, tupleSize);
        this.setLength(buffer, length + 1);
        this.setLength(leftBuffer, --leftLength);
        System.arraycopy(leftBuffer, 24 + (leftLength - 1) * tupleSize + 8, parentBuffer, parentLeftOffset + 8, tupleSize - 8);
    }

    private void mergeLeft(byte[] parentBuffer, byte[] leftBuffer, byte[] buffer, long blockId) {
        long pointer;
        int leftLength = this.getLength(leftBuffer);
        int length = this.getLength(buffer);
        int parentLength = this.getLength(parentBuffer);
        int tupleSize = this._tupleSize;
        int parentOffset = 24;
        int parentEnd = parentOffset + parentLength * tupleSize;
        parentOffset += tupleSize;
        while (parentOffset < parentEnd) {
            pointer = this.getPointer(parentBuffer, parentOffset);
            if (pointer == blockId) {
                int leftOffset = 24 + leftLength * tupleSize;
                this.setPointer(parentBuffer, parentOffset, this.getPointer(parentBuffer, parentOffset - tupleSize));
                if (parentOffset - tupleSize < 24) {
                    throw new IllegalStateException();
                }
                System.arraycopy(parentBuffer, parentOffset, parentBuffer, parentOffset - tupleSize, parentEnd - parentOffset);
                this.setLength(parentBuffer, parentLength - 1);
                this.setPointer(leftBuffer, 16, this.getPointer(buffer, 16));
                if (leftOffset < 24) {
                    throw new IllegalStateException();
                }
                System.arraycopy(buffer, 24, leftBuffer, leftOffset, length * tupleSize);
                this.setLength(leftBuffer, leftLength + length);
                return;
            }
            parentOffset += tupleSize;
        }
        pointer = this.getPointer(parentBuffer, 16);
        if (pointer != blockId) {
            log.warning("BTree remove can't find matching block: " + this.debugId(blockId));
            return;
        }
        int leftOffset = 24 + (parentLength - 1) * tupleSize;
        long leftPointer = this.getPointer(parentBuffer, leftOffset);
        this.setPointer(parentBuffer, 16, leftPointer);
        this.setLength(parentBuffer, parentLength - 1);
        this.setPointer(leftBuffer, 16, this.getPointer(buffer, 16));
        System.arraycopy(buffer, 24, leftBuffer, 24 + leftLength * tupleSize, length * tupleSize);
        this.setLength(leftBuffer, leftLength + length);
    }

    private long getRightBlockId(Block parent, long blockId) {
        int offset;
        byte[] buffer = parent.getBuffer();
        int length = this.getLength(buffer);
        int tupleSize = this._tupleSize;
        int end = offset + length * tupleSize;
        for (offset = 24; offset < end; offset += tupleSize) {
            long pointer = this.getPointer(buffer, offset);
            if (pointer != blockId) continue;
            if (offset + tupleSize < end) {
                return this.getPointer(buffer, offset + tupleSize);
            }
            return this.getPointer(buffer, 16);
        }
        return -1L;
    }

    private void moveFromRight(byte[] parentBuffer, byte[] buffer, byte[] rightBuffer, long blockId) {
        long pointer;
        int parentOffset;
        int parentLength = this.getLength(parentBuffer);
        int tupleSize = this._tupleSize;
        int parentEnd = parentOffset + parentLength * tupleSize;
        int rightLength = this.getLength(rightBuffer);
        int length = this.getLength(buffer);
        for (parentOffset = 24; parentOffset < parentEnd && (pointer = this.getPointer(parentBuffer, parentOffset)) != blockId; parentOffset += tupleSize) {
        }
        if (parentEnd <= parentOffset) {
            log.warning("Can't find buffer in deletion borrow right ");
            return;
        }
        System.arraycopy(rightBuffer, 24, buffer, 24 + length * tupleSize, tupleSize);
        System.arraycopy(rightBuffer, 24 + tupleSize, rightBuffer, 24, (rightLength - 1) * tupleSize);
        this.setLength(buffer, length + 1);
        this.setLength(rightBuffer, rightLength - 1);
        System.arraycopy(buffer, 24 + length * tupleSize + 8, parentBuffer, parentOffset + 8, tupleSize - 8);
    }

    private void mergeRight(byte[] parentBuffer, byte[] buffer, byte[] rightBuffer, long blockId) {
        int parentOffset;
        int parentLength = this.getLength(parentBuffer);
        int tupleSize = this._tupleSize;
        int parentEnd = parentOffset + parentLength * tupleSize;
        int rightLength = this.getLength(rightBuffer);
        int length = this.getLength(buffer);
        for (parentOffset = 24; parentOffset < parentEnd; parentOffset += tupleSize) {
            long pointer = this.getPointer(parentBuffer, parentOffset);
            if (pointer != blockId) continue;
            System.arraycopy(rightBuffer, 24, rightBuffer, 24 + length * tupleSize, rightLength * tupleSize);
            System.arraycopy(buffer, 24, rightBuffer, 24, length * tupleSize);
            this.setLength(rightBuffer, length + rightLength);
            if (parentOffset < 24) {
                throw new IllegalStateException();
            }
            System.arraycopy(parentBuffer, parentOffset + tupleSize, parentBuffer, parentOffset, parentEnd - parentOffset - tupleSize);
            this.setLength(parentBuffer, parentLength - 1);
            return;
        }
        log.warning("BTree merge right can't find matching index: " + this.debugId(blockId));
    }

    private long lookupTuple(long blockId, byte[] buffer, byte[] keyBuffer, int keyOffset, int keyLength, boolean isLeaf) throws IOException {
        int length = this.getLength(buffer);
        int offset = 24;
        int tupleSize = this._tupleSize;
        int end = offset + length * tupleSize;
        while (length > 0) {
            int tail = offset + tupleSize * length;
            int delta = tupleSize * (length / 2);
            int newOffset = offset + delta;
            if (newOffset < 0) {
                System.out.println("UNDERFLOW: " + this.debugId(blockId) + " LENGTH:" + length + " STU:" + this.getLength(buffer) + " DELTA:" + delta);
                throw new IllegalStateException("lookupTuple underflow newOffset:" + newOffset);
            }
            if (newOffset > 65536) {
                System.out.println("OVERFLOW: " + this.debugId(blockId) + " LENGTH:" + length + " STU:" + this.getLength(buffer) + " DELTA:" + delta);
                throw new IllegalStateException("lookupTuple overflow newOffset:" + newOffset);
            }
            int cmp = this._keyCompare.compare(keyBuffer, keyOffset, buffer, 8 + newOffset, keyLength);
            if (cmp == 0) {
                long value = this.getPointer(buffer, newOffset);
                if (value == 0L && !isLeaf) {
                    throw new IllegalStateException("illegal 0 value at " + newOffset + " for block " + this.debugId(blockId));
                }
                return value;
            }
            if (cmp > 0) {
                offset = newOffset + tupleSize;
                length = (tail - offset) / tupleSize;
            } else if (cmp < 0) {
                length /= 2;
            }
            if (length > 0) continue;
            if (isLeaf) {
                return 0L;
            }
            if (cmp < 0) {
                long value = this.getPointer(buffer, newOffset);
                if (value == 0L && !isLeaf) {
                    throw new IllegalStateException("illegal 0 value at " + newOffset + " for block " + this.debugId(blockId));
                }
                return value;
            }
            if (offset == end) {
                long value = this.getPointer(buffer, 16);
                if (value == 0L && !isLeaf) {
                    throw new IllegalStateException("illegal 0 value at " + newOffset + " for block " + this.debugId(blockId));
                }
                return value;
            }
            long value = this.getPointer(buffer, offset);
            if (value == 0L && !isLeaf) {
                throw new IllegalStateException("illegal 0 value at " + newOffset + " for block " + this.debugId(blockId));
            }
            return value;
        }
        if (isLeaf) {
            return 0L;
        }
        long value = this.getPointer(buffer, 16);
        if (value == 0L && !isLeaf) {
            throw new IllegalStateException("illegal 0 value at NEXT_OFFSET for block " + this.debugId(blockId));
        }
        return value;
    }

    private long removeLeafEntry(long blockIndex, byte[] buffer, byte[] keyBuffer, int keyOffset, int keyLength) throws IOException {
        int offset = 24;
        int tupleSize = this._tupleSize;
        int length = this.getLength(buffer);
        for (int i = 0; i < length; ++i) {
            int cmp = this._keyCompare.compare(keyBuffer, keyOffset, buffer, offset + 8, keyLength);
            if (0 < cmp) {
                offset += tupleSize;
                continue;
            }
            if (cmp == 0) {
                int tupleLength = length * tupleSize;
                if (offset + tupleSize < 24 + tupleLength) {
                    if (offset < 24) {
                        throw new IllegalStateException();
                    }
                    System.arraycopy(buffer, offset + tupleSize, buffer, offset, 24 + tupleLength - offset - tupleSize);
                }
                this.setLength(buffer, length - 1);
                return i;
            }
            return 0L;
        }
        return 0L;
    }

    private boolean isLeaf(byte[] buffer) {
        return (this.getInt(buffer, 0) & 1) == 0;
    }

    private void setLeaf(byte[] buffer, boolean isLeaf) {
        if (isLeaf) {
            this.setInt(buffer, 0, this.getInt(buffer, 0) & 0xFFFFFFFE);
        } else {
            this.setInt(buffer, 0, this.getInt(buffer, 0) | 1);
        }
    }

    private int getInt(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + (buffer[offset + 3] & 0xFF);
    }

    private long getPointer(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    private void setInt(byte[] buffer, int offset, int value) {
        buffer[offset + 0] = (byte)(value >> 24);
        buffer[offset + 1] = (byte)(value >> 16);
        buffer[offset + 2] = (byte)(value >> 8);
        buffer[offset + 3] = (byte)value;
    }

    private void setLength(byte[] buffer, int value) {
        if (value < 0 || 65536 / this._tupleSize < value) {
            System.out.println("BAD-LENGTH: " + value);
            throw new IllegalArgumentException("BTree: bad length " + value);
        }
        this.setInt(buffer, 4, value);
    }

    private int getLength(byte[] buffer) {
        int value = this.getInt(buffer, 4);
        if (value < 0 || value > 65536) {
            System.out.println("BAD-LENGTH: " + value);
            throw new IllegalArgumentException("BTree: bad length " + value);
        }
        return value;
    }

    private void setPointer(byte[] buffer, int offset, long value) {
        if (offset <= 4) {
            System.out.println("BAD_POINTER: " + offset);
        }
        buffer[offset + 0] = (byte)(value >> 56);
        buffer[offset + 1] = (byte)(value >> 48);
        buffer[offset + 2] = (byte)(value >> 40);
        buffer[offset + 3] = (byte)(value >> 32);
        buffer[offset + 4] = (byte)(value >> 24);
        buffer[offset + 5] = (byte)(value >> 16);
        buffer[offset + 6] = (byte)(value >> 8);
        buffer[offset + 7] = (byte)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws IOException {
        BTree bTree = this;
        synchronized (bTree) {
            if (this._isStarted) {
                return;
            }
            this._isStarted = true;
        }
    }

    public ArrayList<String> getBlockKeys(long blockIndex) throws IOException {
        long blockId = this._store.addressToBlockId(blockIndex * 65536L);
        if (this._store.isIndexBlock(blockId)) {
            return null;
        }
        Block block = this._store.readBlock(blockId);
        block.read();
        byte[] buffer = block.getBuffer();
        int length = this.getInt(buffer, 4);
        int offset = 24;
        int tupleSize = this._tupleSize;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            keys.add(this._keyCompare.toString(buffer, offset + i * tupleSize + 8, tupleSize - 8));
        }
        block.free();
        return keys;
    }

    public static BTree createTest(Path path, int keySize) throws IOException, SQLException {
        Database db = new Database();
        db.setPath(path);
        db.init();
        Store store = new Store(db, "test", null);
        store.create();
        Block block = store.allocateIndexBlock();
        long blockId = block.getBlockId();
        block.free();
        return new BTree(store, blockId, keySize, new KeyCompare());
    }

    public static BTree createStringTest(Path path, int keySize) throws IOException, SQLException {
        Store store = Store.create(path);
        Block block = store.allocateIndexBlock();
        long blockId = block.getBlockId();
        block.free();
        return new BTree(store, blockId, keySize, new StringKeyCompare());
    }

    private String debugId(long blockId) {
        return "" + blockId % 65536L + ":" + blockId / 65536L;
    }

    public void close() {
        Block rootBlock = this._rootBlock;
        this._rootBlock = null;
        if (rootBlock != null) {
            rootBlock.free();
        }
    }

    public String toString() {
        return "BTree[" + this._store + "," + this._rootBlockId / 65536L + "]";
    }
}

