/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.index;

import com.caucho.db.index.KeyCompare;

public class BinaryKeyCompare
extends KeyCompare {
    public int compare(byte[] keyBuffer, int keyOffset, byte[] block, int offset, int length) {
        int blockLen = block[offset] & 0xFF;
        int keyLen = keyBuffer[keyOffset] & 0xFF;
        int end = keyLen;
        if (blockLen < end) {
            end = blockLen;
        }
        for (int i = 1; i <= end; ++i) {
            int ch1 = keyBuffer[keyOffset + i] & 0xFF;
            int ch2 = block[offset + i] & 0xFF;
            if (ch1 < ch2) {
                return -1;
            }
            if (ch2 >= ch1) continue;
            return 1;
        }
        if (keyLen == blockLen) {
            return 0;
        }
        if (keyLen < blockLen) {
            return -1;
        }
        if (blockLen < keyLen) {
            return 1;
        }
        return 0;
    }

    public String toString(byte[] buffer, int offset, int length) {
        int ch;
        StringBuilder sb = new StringBuilder();
        int keyLen = buffer[offset];
        for (int j = 0; j < keyLen && (ch = buffer[offset + 1 + j] & 0xFF) != 0; ++j) {
            if (ch < 128) {
                sb.append((char)ch);
                continue;
            }
            if ((ch & 0xE0) == 192) {
                int ch1 = buffer[offset + 1 + j] & 0xFF;
                sb.append((char)(((ch & 0xF) << 6) + (ch & 0x3F)));
                ++j;
                continue;
            }
            int ch2 = buffer[offset + 1 + j] & 0xFF;
            int ch3 = buffer[offset + 2 + j] & 0xFF;
            sb.append((char)(((ch & 0xF) << 12) + ((ch & 0x3F) << 6) + (ch & 0x3F)));
            j += 2;
        }
        return sb.toString();
    }
}

