/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.Database;
import com.caucho.db.jdbc.DatabaseMetaDataImpl;
import com.caucho.db.jdbc.PooledConnectionImpl;
import com.caucho.db.jdbc.PreparedStatementImpl;
import com.caucho.db.jdbc.StatementImpl;
import com.caucho.db.sql.Query;
import com.caucho.db.store.Transaction;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionImpl
implements Connection {
    private static final L10N L = new L10N(ConnectionImpl.class);
    private static final Logger log = Log.open(ConnectionImpl.class);
    private Database _db;
    private PooledConnectionImpl _pooledConnection;
    private boolean _isClosed;
    private boolean _isAutoCommit = true;
    private Transaction _xa;
    private StatementImpl _statement;
    private ArrayList<StatementImpl> _statements;

    public ConnectionImpl(PooledConnectionImpl pooledConnection) {
        this._pooledConnection = pooledConnection;
        this._db = pooledConnection.getDatabase();
        if (this._db == null) {
            throw new NullPointerException();
        }
    }

    public ConnectionImpl(Database db) {
        this._db = db;
        if (this._db == null) {
            throw new NullPointerException();
        }
    }

    Database getDatabase() {
        return this._db;
    }

    @Override
    public void clearWarnings() {
    }

    public void setTransaction(Transaction xa) {
        this._xa = xa;
    }

    public Transaction getTransaction() {
        if (this._isAutoCommit) {
            Transaction xa = Transaction.create(this);
            xa.setAutoCommit(true);
            return xa;
        }
        if (this._xa == null) {
            this._xa = Transaction.create(this);
            if (log.isLoggable(Level.FINER)) {
                log.finer("start transaction " + this + " " + this._xa);
            }
        }
        this._xa.setAutoCommit(false);
        return this._xa;
    }

    @Override
    public void commit() throws SQLException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("commit " + this + " " + this._xa);
        }
        Transaction xa = this._xa;
        this._xa = null;
        if (xa != null) {
            xa.commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        Transaction xa = this._xa;
        this._xa = null;
        if (xa != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("rollback " + this + " " + this._xa);
            }
            xa.rollback();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this._db == null) {
            throw new SQLException(L.l("Connection is already closed"));
        }
        StatementImpl stmt = new StatementImpl(this);
        if (this._statement == null) {
            this._statement = stmt;
        } else {
            if (this._statements == null) {
                this._statements = new ArrayList();
            }
            this._statements.add(stmt);
        }
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public boolean getAutoCommit() {
        return this._isAutoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!this._isAutoCommit && autoCommit) {
            Transaction xa = this._xa;
            this._xa = null;
            if (xa != null) {
                xa.commit();
            }
        }
        this._isAutoCommit = autoCommit;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new DatabaseMetaDataImpl(this);
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int level) {
    }

    public Map getTypeMap() {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public boolean isClosed() {
        return this._isClosed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public String nativeSQL(String sql) {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatementImpl(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatementImpl pstmt = this.prepareStatementImpl(sql);
        if (autoGeneratedKeys == 1) {
            pstmt.setReturnGeneratedKeys(true);
        }
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndices) throws SQLException {
        PreparedStatementImpl pstmt = this.prepareStatementImpl(sql);
        pstmt.setReturnGeneratedKeys(true);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatementImpl pstmt = this.prepareStatementImpl(sql);
        pstmt.setReturnGeneratedKeys(true);
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql);
    }

    private PreparedStatementImpl prepareStatementImpl(String sql) throws SQLException {
        Query query = this._db.parseQuery(sql);
        PreparedStatementImpl stmt = new PreparedStatementImpl(this, query);
        if (this._statement == null) {
            this._statement = stmt;
        } else {
            if (this._statements == null) {
                this._statements = new ArrayList();
            }
            this._statements.add(stmt);
        }
        return stmt;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint(String savepoint) throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public void setHoldability(int hold) throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int holdability) throws SQLException {
        return null;
    }

    void closeStatement(StatementImpl stmt) {
        if (this._statement == stmt) {
            this._statement = null;
        }
        if (this._statements != null) {
            this._statements.remove(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            this._db = null;
        }
        StatementImpl stmt = this._statement;
        this._statement = null;
        if (stmt != null) {
            this._statement = null;
        }
        if (this._statements != null) {
            for (int i = 0; i < this._statements.size(); ++i) {
                stmt = this._statements.get(i);
                stmt.close();
            }
        }
        if (this._pooledConnection != null) {
            this._pooledConnection.closeEvent(this);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

