/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.Database;
import com.caucho.db.jdbc.PooledConnectionImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class ConnectionPoolDataSourceImpl
implements ConnectionPoolDataSource {
    private static final Logger log = Logger.getLogger(ConnectionPoolDataSourceImpl.class.getName());
    private static final L10N L = new L10N(ConnectionPoolDataSourceImpl.class);
    private Database _database = new Database();
    private boolean _createDatabase;
    private boolean _isInit;

    public void setPath(Path path) {
        this._database.setPath(path);
    }

    public void setURL(String url) {
        if (url.startsWith("jdbc:")) {
            url = url.substring(5);
        }
        if (url.startsWith("resin:")) {
            url = url.substring(6);
        }
        this._database.setPath(Vfs.lookup(url));
    }

    public void setCreateDatabase(boolean create) {
        this._createDatabase = create;
    }

    public void setRemoveOnError(boolean remove) {
        this._database.setRemoveOnError(remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SQLException {
        ConnectionPoolDataSourceImpl connectionPoolDataSourceImpl = this;
        synchronized (connectionPoolDataSourceImpl) {
            if (this._isInit) {
                return;
            }
            try {
                this._database.init();
                Object var3_2 = null;
                this._isInit = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._isInit = true;
                throw throwable;
            }
        }
    }

    public int getLoginTimeout() {
        return 0;
    }

    public void setLoginTimeout(int foo) {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void setLogWriter(PrintWriter log) {
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return this.getPooledConnection();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        this.init();
        return new PooledConnectionImpl(this._database);
    }

    public String toString() {
        return "ConnectionPoolDataSourceImpl[" + this._database.getPath() + "]";
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._database.close();
    }
}

