/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.Database;
import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceImpl
implements DataSource {
    private static final Logger log = Log.open(DataSourceImpl.class);
    private static final L10N L = new L10N(DataSourceImpl.class);
    private Database _database = new Database();
    private boolean _createDatabase;
    private boolean _isInit;

    public DataSourceImpl() {
    }

    public DataSourceImpl(Path path) throws SQLException {
        this();
        this.setPath(path);
        this.init();
    }

    public void setPath(Path path) {
        this._database.setPath(path);
    }

    public void setCreateDatabase(boolean create) {
        this._createDatabase = create;
    }

    public void setRemoveOnError(boolean remove) {
        this._database.setRemoveOnError(remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SQLException {
        DataSourceImpl dataSourceImpl = this;
        synchronized (dataSourceImpl) {
            if (this._isInit) {
                return;
            }
            try {
                this._database.init();
                Object var3_2 = null;
                this._isInit = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._isInit = true;
                throw throwable;
            }
        }
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public void setLoginTimeout(int foo) {
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter log) {
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.init();
        return new ConnectionImpl(this._database);
    }

    public void close() {
        this._database.close();
    }

    public String toString() {
        return "DataSourceImpl[" + this._database.getPath() + "]";
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._database.close();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

