/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.Database;
import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.jdbc.NullResultSet;
import com.caucho.db.jdbc.ResultSetImpl;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectQuery;
import com.caucho.db.store.Transaction;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementImpl
implements Statement {
    private static final L10N L = new L10N(StatementImpl.class);
    protected Database _db;
    protected final ConnectionImpl _conn;
    protected ResultSetImpl _rs;
    protected QueryContext _queryContext;
    private boolean _isClosed;

    StatementImpl(ConnectionImpl conn) {
        this._conn = conn;
        this._db = conn.getDatabase();
        if (this._db == null) {
            throw new NullPointerException();
        }
        this.init();
    }

    protected void init() {
        if (this._queryContext == null) {
            this._queryContext = QueryContext.allocate();
        }
    }

    protected QueryContext getQueryContext() {
        if (this._queryContext == null) {
            this._queryContext = QueryContext.allocate();
        }
        return this._queryContext;
    }

    @Override
    public void addBatch(String sql) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void clearBatch() {
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this._db == null) {
            throw new SQLException(L.l("statement is closed"));
        }
        Query query = this._db.parseQuery(sql);
        return this.executeQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultSet executeQuery(Query query) throws SQLException {
        block5: {
            Transaction xa;
            block4: {
                xa = this._conn.getTransaction();
                boolean isOkay = false;
                try {
                    query.execute(this._queryContext, xa);
                    isOkay = true;
                    Object var5_4 = null;
                    if (xa.isAutoCommit()) break block4;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!xa.isAutoCommit()) {
                        throw throwable;
                    }
                    if (isOkay) {
                        xa.commit();
                        throw throwable;
                    }
                    xa.rollback();
                    throw throwable;
                }
            }
            xa.commit();
        }
        this._rs = new ResultSetImpl(this, this._queryContext.getResult());
        return this._rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        Query query = this._db.parseQuery(sql);
        return this.executeUpdate(query);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        Query query = this._db.parseQuery(sql);
        this._queryContext.setReturnGeneratedKeys(true);
        return this.executeUpdate(query);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        Query query = this._db.parseQuery(sql);
        this._queryContext.setReturnGeneratedKeys(true);
        return this.executeUpdate(query);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        Query query = this._db.parseQuery(sql);
        this._queryContext.setReturnGeneratedKeys(true);
        return this.executeUpdate(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int executeUpdate(Query query) throws SQLException {
        Transaction xa = this._conn.getTransaction();
        boolean isOkay = false;
        this._queryContext.setTransaction(xa);
        try {
            query.execute(this._queryContext, xa);
            isOkay = true;
            Object var5_4 = null;
            if (!xa.isAutoCommit()) return this._queryContext.getRowUpdateCount();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!xa.isAutoCommit()) throw throwable;
            if (isOkay) {
                xa.commit();
                throw throwable;
            } else {
                xa.rollback();
            }
            throw throwable;
        }
        xa.commit();
        return this._queryContext.getRowUpdateCount();
    }

    @Override
    public ResultSet getGeneratedKeys() {
        GeneratedKeysResultSet rs = this._queryContext.getGeneratedKeysResultSet();
        if (rs != null) {
            return rs;
        }
        return new NullResultSet();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Query query = this._db.parseQuery(sql);
        if (query instanceof SelectQuery) {
            this.executeQuery(query);
            return true;
        }
        this.executeUpdate(query);
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet() {
        return this._rs;
    }

    @Override
    public int getUpdateCount() {
        return this._queryContext.getRowUpdateCount();
    }

    @Override
    public Connection getConnection() {
        return this._conn;
    }

    @Override
    public int getFetchDirection() {
        return 0;
    }

    @Override
    public int getFetchSize() {
        return this._queryContext.getLimit();
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public void setMaxRows(int max) {
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public int getQueryTimeout() {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() {
        return 0;
    }

    @Override
    public int getResultSetType() {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void setCursorName(String name) {
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public void setFetchSize(int rows) {
        this._queryContext.setLimit(rows);
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public void setQueryTimeout(int seconds) {
    }

    @Override
    public boolean getMoreResults(int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String query, int foo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String query, int[] foo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String query, String[] foo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
        this._db = null;
        ResultSetImpl rs = this._rs;
        this._rs = null;
        QueryContext queryContext = this._queryContext;
        this._queryContext = null;
        if (rs != null) {
            rs.close();
        }
        this._conn.closeStatement(this);
        if (queryContext != null) {
            QueryContext.free(queryContext);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

