/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.log.Log;
import java.sql.SQLException;
import java.util.logging.Logger;

class AutoIncrementExpr
extends Expr {
    private static final Logger log = Log.open(AutoIncrementExpr.class);
    private Table _table;

    AutoIncrementExpr(Table table) {
        this._table = table;
    }

    public Class getType() {
        return Long.TYPE;
    }

    public long evalLong(QueryContext context) throws SQLException {
        long value = this._table.nextAutoIncrement(context);
        GeneratedKeysResultSet keysRS = context.getGeneratedKeysResultSet();
        if (keysRS != null) {
            Column column = this._table.getAutoIncrementColumn();
            keysRS.setColumn(1, column);
            keysRS.setLong(1, value);
        }
        return value;
    }

    public double evalDouble(QueryContext context) throws SQLException {
        return this.evalLong(context);
    }

    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this.evalLong(context));
    }

    public String toString() {
        return "auto_increment()";
    }
}

