/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.NullExpr;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BooleanLiteralExpr
extends Expr {
    private static final Logger log = Log.open(NullExpr.class);
    private static BooleanLiteralExpr TRUE_EXPR = new BooleanLiteralExpr(true);
    private static BooleanLiteralExpr FALSE_EXPR = new BooleanLiteralExpr(false);
    private final boolean _value;

    private BooleanLiteralExpr(boolean value) {
        this._value = value;
    }

    static BooleanLiteralExpr create(boolean value) {
        return value ? TRUE_EXPR : FALSE_EXPR;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return false;
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return 0L;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return this._value ? "1" : "0";
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        return this._value ? 1 : 0;
    }

    public String toString() {
        return this._value ? "TRUE" : "FALSE";
    }
}

