/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FunExpr;
import com.caucho.db.sql.GroupExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.logging.Logger;

public class CountExpr
extends FunExpr
implements GroupExpr {
    protected static final L10N L = new L10N(CountExpr.class);
    private static final Logger log = Log.open(CountExpr.class);
    private Expr _expr;
    private int _groupField;

    protected void addArg(Expr expr) throws SQLException {
        if (this._expr != null) {
            throw new SQLException(L.l("max requires a single argument"));
        }
        this._expr = expr;
    }

    protected Expr bind(Query query) throws SQLException {
        this._groupField = query.getDataFields();
        query.setDataFields(this._groupField + 1);
        query.setGroup(true);
        this._expr = this._expr.bind(query);
        return this;
    }

    public Class getType() {
        return Long.TYPE;
    }

    public void initGroup(QueryContext context) throws SQLException {
        context.setGroupDouble(this._groupField, 0.0);
    }

    public void evalGroup(QueryContext context) throws SQLException {
        if (this._expr.isNull(context)) {
            return;
        }
        double oldValue = context.getGroupDouble(this._groupField);
        context.setGroupDouble(this._groupField, oldValue + 1.0);
    }

    public boolean isNull(QueryContext context) throws SQLException {
        return context.isGroupNull(this._groupField);
    }

    public double evalDouble(QueryContext context) throws SQLException {
        return context.getGroupDouble(this._groupField);
    }

    public long evalLong(QueryContext context) throws SQLException {
        return (long)this.evalDouble(context);
    }

    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this.evalLong(context));
    }
}

