/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.table.Column;

public class Data {
    private static final int NULL = 0;
    private static final int BOOLEAN = 1;
    private static final int STRING = 2;
    private static final int INTEGER = 3;
    private static final int LONG = 4;
    private static final int DOUBLE = 5;
    private static final int EXPR = 6;
    private Column _column;
    private int _type;
    private boolean _booleanData;
    private String _stringData;
    private int _intData;
    private long _longData;
    private double _doubleData;
    private Expr _expr;

    public void clear() {
        this._type = 0;
    }

    public void setColumn(Column column) {
        this._column = column;
    }

    public Column getColumn() {
        return this._column;
    }

    public boolean isNull() {
        return this._type == 0;
    }

    public void setString(String value) {
        if (value == null) {
            this._type = 0;
        } else {
            this._type = 2;
            this._stringData = value;
        }
    }

    public String getString() {
        switch (this._type) {
            case 0: {
                return null;
            }
            case 1: {
                return this._booleanData ? "true" : "false";
            }
            case 3: {
                return String.valueOf(this._intData);
            }
            case 4: {
                return String.valueOf(this._longData);
            }
            case 5: {
                return String.valueOf(this._doubleData);
            }
            case 2: {
                return this._stringData;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setBoolean(boolean value) {
        this._type = 1;
        this._booleanData = value;
    }

    public int getBoolean() {
        switch (this._type) {
            case 0: {
                return -1;
            }
            case 1: {
                return this._booleanData ? 1 : 0;
            }
            case 3: {
                return this._intData != 0 ? 1 : 0;
            }
            case 4: {
                return this._longData != 0L ? 1 : 0;
            }
            case 5: {
                return this._doubleData != 0.0 ? 1 : 0;
            }
            case 2: {
                return this._stringData.equalsIgnoreCase("y") ? 1 : 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setInt(int value) {
        this._type = 3;
        this._intData = value;
    }

    public int getInt() {
        switch (this._type) {
            case 0: {
                return 0;
            }
            case 1: {
                return this._booleanData ? 1 : 0;
            }
            case 3: {
                return this._intData;
            }
            case 4: {
                return (int)this._longData;
            }
            case 5: {
                return (int)this._doubleData;
            }
            case 2: {
                return Integer.parseInt(this._stringData);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setLong(long value) {
        this._type = 4;
        this._longData = value;
    }

    public long getLong() {
        switch (this._type) {
            case 0: {
                return 0L;
            }
            case 1: {
                return this._booleanData ? 1L : 0L;
            }
            case 3: {
                return this._intData;
            }
            case 4: {
                return this._longData;
            }
            case 5: {
                return (long)this._doubleData;
            }
            case 2: {
                return Long.parseLong(this._stringData);
            }
        }
        throw new UnsupportedOperationException();
    }

    public long getDate() {
        switch (this._type) {
            case 0: {
                return 0L;
            }
            case 1: {
                return this._booleanData ? 1L : 0L;
            }
            case 3: {
                return this._intData;
            }
            case 4: {
                return this._longData;
            }
            case 5: {
                return (long)this._doubleData;
            }
            case 2: {
                return Long.parseLong(this._stringData);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setDouble(double value) {
        this._type = 5;
        this._doubleData = value;
    }

    public double getDouble() {
        switch (this._type) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return this._booleanData ? 1.0 : 0.0;
            }
            case 3: {
                return this._intData;
            }
            case 4: {
                return this._longData;
            }
            case 5: {
                return this._doubleData;
            }
            case 2: {
                return Double.parseDouble(this._stringData);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void copyTo(Data dst) {
        switch (this._type) {
            case 0: {
                dst.setString(null);
                break;
            }
            case 1: {
                dst.setBoolean(this._booleanData);
                break;
            }
            case 3: {
                dst.setInt(this._intData);
                break;
            }
            case 4: {
                dst.setLong(this._longData);
                break;
            }
            case 5: {
                dst.setDouble(this._doubleData);
                break;
            }
            case 2: {
                dst.setString(this._stringData);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int hashCode() {
        switch (this._type) {
            case 0: {
                return 17;
            }
            case 1: {
                return this._booleanData ? 1 : 0;
            }
            case 3: {
                return this._intData;
            }
            case 4: {
                return (int)this._longData;
            }
            case 5: {
                return (int)this._doubleData;
            }
            case 2: {
                return this._stringData.hashCode();
            }
        }
        return 97;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Data data = (Data)o;
        if (this._type != data._type) {
            return false;
        }
        switch (this._type) {
            case 0: {
                return false;
            }
            case 1: {
                return this._booleanData == data._booleanData;
            }
            case 3: {
                return this._intData == data._intData;
            }
            case 4: {
                return this._longData == data._longData;
            }
            case 5: {
                return this._doubleData == data._doubleData;
            }
            case 2: {
                return this._stringData.equals(data._stringData);
            }
        }
        return false;
    }
}

