/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DoubleExpr
extends Expr {
    private static final Logger log = Log.open(DoubleExpr.class);
    private double _value;

    DoubleExpr(double value) {
        this._value = value;
    }

    @Override
    public Class getType() {
        return Double.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return 0L;
    }

    public int evalInt(QueryContext context) throws SQLException {
        return (int)this._value;
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        return (long)this._value;
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return this._value;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this._value);
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

