/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.DoubleOrder;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.IntOrder;
import com.caucho.db.sql.LongOrder;
import com.caucho.db.sql.Order;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.sql.StringOrder;
import com.caucho.db.table.Table;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.io.InputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expr {
    protected static final L10N L = new L10N(Expr.class);
    private static final Logger log = Log.open(Expr.class);
    public static final int UNKNOWN = -1;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    static final long COST_INVALID = 9223372036854775L;
    static final long COST_NO_TABLE = Integer.MAX_VALUE;
    static final long COST_SCAN = 1000000L;
    static final long COST_UNIQUE = 10000L;
    static final long COST_INDEX = 100L;
    static final long COST_CONSTANT = 0L;
    private static QDate _gmtDate = new QDate();

    protected Expr bind(Query query) throws SQLException {
        return this;
    }

    public Class getType() {
        return Object.class;
    }

    public boolean isLong() {
        Class type = this.getType();
        return Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Date.class.equals((Object)type);
    }

    public boolean isDouble() {
        Class type = this.getType();
        return this.isLong() || Double.TYPE.isAssignableFrom(type);
    }

    public boolean isBoolean() {
        return Boolean.TYPE.equals(this.getType());
    }

    public boolean isBinaryStream() {
        Class type = this.getType();
        return InputStream.class.equals((Object)type);
    }

    public String getName() {
        return "";
    }

    public int getSQLType() {
        return 12;
    }

    public Table getTable() {
        return null;
    }

    public void splitAnd(ArrayList<Expr> andProduct) {
        andProduct.add(this);
    }

    public long cost(ArrayList<FromItem> fromList) {
        return this.subCost(fromList);
    }

    public long subCost(ArrayList<FromItem> fromList) {
        return 9223372036854775L;
    }

    public RowIterateExpr getIndexExpr(FromItem fromItem) {
        return null;
    }

    public Order createOrder(int index) {
        if (Integer.TYPE.equals(this.getType())) {
            return new IntOrder(index);
        }
        if (this.isLong()) {
            return new LongOrder(index);
        }
        if (this.isDouble()) {
            return new DoubleOrder(index);
        }
        return new StringOrder(index);
    }

    public boolean isNull(QueryContext context) throws SQLException {
        return false;
    }

    public boolean isSelect(QueryContext context) throws SQLException {
        return this.evalBoolean(context) == 1;
    }

    public int evalBoolean(QueryContext context) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String evalString(QueryContext context) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long evalLong(QueryContext context) throws SQLException {
        String strValue = this.evalString(context);
        if (strValue == null) {
            return 0L;
        }
        return Long.parseLong(strValue);
    }

    public double evalDouble(QueryContext context) throws SQLException {
        String strValue = this.evalString(context);
        if (strValue == null) {
            return 0.0;
        }
        return Double.parseDouble(strValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long evalDate(QueryContext context) throws SQLException {
        String dateString = this.evalString(context);
        try {
            QDate qDate = _gmtDate;
            synchronized (qDate) {
                return _gmtDate.parseDate(dateString);
            }
        }
        catch (Exception e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    public void evalToResult(QueryContext context, SelectResult result) throws SQLException {
        String s = this.evalString(context);
        if (s == null) {
            result.writeNull();
            return;
        }
        result.writeString(s);
    }

    public InputStream evalStream(QueryContext context) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int evalToBuffer(QueryContext context, byte[] buffer, int columnType) throws SQLException {
        switch (columnType) {
            case 2: {
                int v = (int)this.evalLong(context);
                buffer[0] = (byte)(v >> 24);
                buffer[1] = (byte)(v >> 16);
                buffer[2] = (byte)(v >> 8);
                buffer[3] = (byte)v;
                return 4;
            }
            case 3: 
            case 5: {
                long v = this.evalLong(context);
                buffer[0] = (byte)(v >> 56);
                buffer[1] = (byte)(v >> 48);
                buffer[2] = (byte)(v >> 40);
                buffer[3] = (byte)(v >> 32);
                buffer[4] = (byte)(v >> 24);
                buffer[5] = (byte)(v >> 16);
                buffer[6] = (byte)(v >> 8);
                buffer[7] = (byte)v;
                return 8;
            }
            case 1: {
                String v = this.evalString(context);
                if (v == null) {
                    return -1;
                }
                int length = v.length();
                int offset = 0;
                buffer[offset++] = (byte)length;
                for (int i = 0; i < length; ++i) {
                    char ch = v.charAt(i);
                    buffer[offset++] = (byte)(ch >> 8);
                    buffer[offset++] = (byte)ch;
                }
                return offset;
            }
            case 8: {
                String v = this.evalString(context);
                if (v == null) {
                    return -1;
                }
                int length = v.length();
                int offset = 1;
                for (int i = 0; i < length; ++i) {
                    char ch = v.charAt(i);
                    if (ch < '\u0080') {
                        buffer[offset++] = (byte)(ch & 0xFF);
                        continue;
                    }
                    if (ch < '\u0800') {
                        buffer[offset++] = (byte)(192 + (ch >> 6 & 0x1F));
                        buffer[offset++] = (byte)(128 + (ch & 0x3F));
                        continue;
                    }
                    buffer[offset++] = (byte)(224 + (ch >> 12 & 0xF));
                    buffer[offset++] = (byte)(128 + (ch >> 6 & 0x3F));
                    buffer[offset++] = (byte)(128 + (ch & 0x3F));
                }
                buffer[0] = (byte)(offset - 1);
                return offset;
            }
        }
        throw new UnsupportedOperationException("unknown column: " + columnType);
    }

    public void initGroup(QueryContext context) throws SQLException {
    }

    public void evalGroup(QueryContext context) throws SQLException {
    }
}

