/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InExpr
extends Expr {
    private static final Logger log = Log.open(InExpr.class);
    private Expr _expr;
    private final HashSet<String> _values;
    private final boolean _isNot;

    InExpr(Expr expr, HashSet<String> values, boolean isNot) {
        this._expr = expr;
        this._values = values;
        this._isNot = isNot;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        return this;
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._expr.subCost(fromList);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        if (this._values.contains(this._expr.evalString(context))) {
            return this._isNot ? 0 : 1;
        }
        return this._isNot ? 1 : 0;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return this.evalBoolean(context) == 1 ? "1" : "0";
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._expr.evalGroup(context);
    }

    public String toString() {
        return this._expr + " IN " + this._values;
    }
}

