/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.index.BTree;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.IdExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.table.Column;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;

class IndexExpr
extends RowIterateExpr {
    private static final Logger log = Log.open(IndexExpr.class);
    private IdExpr _columnExpr;
    private Column _column;
    private BTree _index;
    private Expr _expr;

    IndexExpr(IdExpr index, Expr expr) {
        this._expr = expr;
        this._columnExpr = index;
        if (expr == null || index == null) {
            throw new NullPointerException();
        }
        this._column = index.getColumn();
        this._index = this._column.getIndex();
        if (this._index == null) {
            throw new IllegalArgumentException();
        }
    }

    protected Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        return this;
    }

    boolean allowChildRowShift(QueryContext context, TableIterator rowIter) {
        return false;
    }

    boolean init(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.init(context);
        return true;
    }

    boolean initRow(QueryContext context, TableIterator tableIter) throws SQLException, IOException {
        long rowAddr = this.evalIndex(context);
        if (rowAddr == 0L) {
            return false;
        }
        context.unlock();
        tableIter.setRow(rowAddr);
        context.lock();
        return true;
    }

    boolean nextRow(QueryContext context, TableIterator table) {
        return false;
    }

    long evalIndex(QueryContext context) throws SQLException {
        byte[] buffer = context.getBuffer();
        int length = this._expr.evalToBuffer(context, buffer, this._column.getTypeCode());
        if (length <= 0) {
            return 0L;
        }
        try {
            long index = this._index.lookup(buffer, 0, length, context.getTransaction());
            return index;
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    boolean nextBlock(QueryContext context, TableIterator rowIter) throws IOException {
        return false;
    }

    public String toString() {
        return "(" + this._columnExpr + " = " + this._expr + ")";
    }
}

