/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.log.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LongExpr
extends Expr {
    private static final Logger log = Log.open(LongExpr.class);
    private long _value;

    LongExpr(long value) {
        this._value = value;
    }

    @Override
    public Class getType() {
        return Long.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return 0L;
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        return this._value;
    }

    @Override
    public long evalDate(QueryContext context) throws SQLException {
        return this._value;
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return this._value;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this._value);
    }

    @Override
    public void evalToResult(QueryContext context, SelectResult result) {
        result.writeLong(this._value);
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

