/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FunExpr;
import com.caucho.db.sql.GroupExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.logging.Logger;

public class MaxExpr
extends FunExpr
implements GroupExpr {
    protected static final L10N L = new L10N(MaxExpr.class);
    private static final Logger log = Log.open(MaxExpr.class);
    private Expr _expr;
    private int _dataField;

    protected void addArg(Expr expr) throws SQLException {
        if (this._expr != null) {
            throw new SQLException(L.l("max requires a single argument"));
        }
        this._expr = expr;
    }

    protected Expr bind(Query query) throws SQLException {
        this._dataField = query.getDataFields();
        query.setDataFields(this._dataField + 1);
        query.setGroup(true);
        this._expr = this._expr.bind(query);
        return this;
    }

    public Class getType() {
        return this._expr.getType();
    }

    public void evalGroup(QueryContext context) throws SQLException {
        if (this._expr.isNull(context)) {
            return;
        }
        double value = this._expr.evalDouble(context);
        double oldValue = context.getGroupDouble(this._dataField);
        if (context.isGroupNull(this._dataField)) {
            context.setGroupDouble(this._dataField, value);
        } else if (oldValue < value) {
            context.setGroupDouble(this._dataField, value);
        }
    }

    public boolean isNull(QueryContext context) throws SQLException {
        return context.isGroupNull(this._dataField);
    }

    public double evalDouble(QueryContext context) throws SQLException {
        if (context.isGroupNull(this._dataField)) {
            return 0.0;
        }
        return context.getGroupDouble(this._dataField);
    }

    public long evalLong(QueryContext context) throws SQLException {
        return (long)this.evalDouble(context);
    }

    public String evalString(QueryContext context) throws SQLException {
        if (context.isGroupNull(this._dataField)) {
            return null;
        }
        double value = context.getGroupDouble(this._dataField);
        return String.valueOf((long)value);
    }

    public String toString() {
        return "max(" + this._expr + ")";
    }
}

