/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrExpr
extends Expr {
    private static final Logger log = Log.open(OrExpr.class);
    private Expr _left;
    private Expr _right;

    OrExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        Expr newLeft = this._left.bind(query);
        Expr newRight = this._right.bind(query);
        if (!newLeft.isBoolean()) {
            throw new SQLException(L.l("OR requires boolean operands"));
        }
        if (!newRight.isBoolean()) {
            throw new SQLException(L.l("OR requires boolean operands"));
        }
        if (this._left == newLeft && this._right == newRight) {
            return this;
        }
        return new OrExpr(newLeft, newRight);
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this.evalBoolean(context) == -1;
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        int leftValue = this._left.evalBoolean(context);
        if (leftValue == 1) {
            return 1;
        }
        int rightValue = this._right.evalBoolean(context);
        if (rightValue == 1) {
            return 1;
        }
        if (leftValue == 0 && rightValue == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        switch (this.evalBoolean(context)) {
            case 1: {
                return "1";
            }
            case 0: {
                return "0";
            }
        }
        return null;
    }

    public String toString() {
        return "(" + this._left + " OR " + this._right + ")";
    }
}

