/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.caucho.util.QDate;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParamExpr
extends Expr {
    private static final Logger log = Log.open(ParamExpr.class);
    private static final int NULL = 0;
    private static final int BOOLEAN = 1;
    private static final int STRING = 2;
    private static final int LONG = 3;
    private static final int DOUBLE = 4;
    private static final int DATE = 5;
    private static final int BINARY = 6;
    private int _index;
    private int _type = 0;
    private String _stringValue;
    private long _longValue;
    private double _doubleValue;
    private InputStream _binaryStream;
    private int _streamLength;

    ParamExpr(int index) {
        this._index = index;
    }

    @Override
    public Class getType() {
        switch (this._type) {
            case 0: {
                return Object.class;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Long.TYPE;
            }
            case 4: {
                return Double.TYPE;
            }
            case 5: {
                return Date.class;
            }
            case 6: {
                return InputStream.class;
            }
        }
        return Object.class;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return 0L;
    }

    public void clear() {
        this._type = 0;
    }

    public void setString(String value) {
        if (value == null) {
            this._type = 0;
        } else {
            this._type = 2;
            this._stringValue = value;
        }
    }

    public void setBoolean(boolean value) {
        this._type = 1;
        this._longValue = value ? 1L : 0L;
    }

    public void setLong(long value) {
        this._type = 3;
        this._longValue = value;
    }

    public void setDouble(double value) {
        this._type = 4;
        this._doubleValue = value;
    }

    public void setDate(long value) {
        this._type = 5;
        this._longValue = value;
    }

    public void setBinaryStream(InputStream is, int length) {
        this._type = 6;
        this._binaryStream = is;
        this._streamLength = length;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this._type == 0;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        switch (this._type) {
            case 0: {
                return null;
            }
            case 1: {
                return this._longValue != 0L ? "1" : "0";
            }
            case 2: {
                return this._stringValue;
            }
            case 3: {
                return String.valueOf(this._longValue);
            }
            case 5: {
                return QDate.formatISO8601((long)this._longValue);
            }
            case 4: {
                return String.valueOf(this._doubleValue);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(this._type));
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        switch (this._type) {
            case 0: {
                return -1;
            }
            case 1: 
            case 3: {
                return this._longValue != 0L ? 1 : 0;
            }
            case 4: {
                return this._doubleValue != 0.0 ? 1 : 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        switch (this._type) {
            case 0: {
                return 0L;
            }
            case 1: 
            case 3: 
            case 5: {
                return this._longValue;
            }
            case 4: {
                return (long)this._doubleValue;
            }
            case 2: {
                return Long.parseLong(this._stringValue);
            }
        }
        throw new UnsupportedOperationException("" + this._type);
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        switch (this._type) {
            case 0: {
                return 0.0;
            }
            case 3: 
            case 5: {
                return this._longValue;
            }
            case 4: {
                return this._doubleValue;
            }
            case 2: {
                return Double.parseDouble(this._stringValue);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long evalDate(QueryContext context) throws SQLException {
        switch (this._type) {
            case 0: {
                return 0L;
            }
            case 3: 
            case 5: {
                return this._longValue;
            }
            case 4: {
                return (long)this._doubleValue;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream evalStream(QueryContext context) throws SQLException {
        switch (this._type) {
            case 0: {
                return null;
            }
            case 6: {
                return this._binaryStream;
            }
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "?" + this._index;
    }
}

