/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.sql.Data;
import com.caucho.db.sql.GroupItem;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.Block;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.NullIterator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryContext {
    private static final Logger log = Log.open(QueryContext.class);
    private static final L10N L = new L10N(QueryContext.class);
    private static final long LOCK_TIMEOUT = 120000L;
    private static final FreeList<QueryContext> _freeList = new FreeList(64);
    private Transaction _xa;
    private TableIterator[] _tableIterators;
    private boolean _isWrite;
    private Data[] _parameters = new Data[8];
    private GroupItem _tempGroupItem;
    private GroupItem _groupItem;
    private boolean _isReturnGeneratedKeys;
    private SelectResult _result;
    private GeneratedKeysResultSet _generatedKeys;
    private int _rowUpdateCount;
    private int _limit = -1;
    private Block[] _blockLocks;
    private boolean _isLocked;
    private HashMap<GroupItem, GroupItem> _groupMap;
    private byte[] _buffer = new byte[256];

    private QueryContext() {
        this._tempGroupItem = GroupItem.allocate(new boolean[8]);
    }

    public static QueryContext allocate() {
        QueryContext queryContext = (QueryContext)_freeList.allocate();
        if (queryContext == null) {
            queryContext = new QueryContext();
        }
        queryContext.clearParameters();
        queryContext._limit = -1;
        return queryContext;
    }

    public void clearParameters() {
        for (int i = this._parameters.length - 1; i >= 0; --i) {
            if (this._parameters[i] == null) {
                this._parameters[i] = new Data();
            }
            this._parameters[i].clear();
        }
    }

    public void init(Transaction xa, TableIterator[] tableIterators, boolean isReadOnly) {
        this._xa = xa;
        this._isWrite = !isReadOnly;
        this._tableIterators = tableIterators;
        this._blockLocks = new Block[this._tableIterators.length];
        this._isLocked = false;
        this._rowUpdateCount = 0;
        this._groupItem = this._tempGroupItem;
        this._groupItem.init(0, null);
    }

    public void initGroup(int size, boolean[] isGroupByFields) {
        this._groupItem = this._tempGroupItem;
        this._groupItem.init(size, isGroupByFields);
        if (this._groupMap == null) {
            this._groupMap = new HashMap();
        }
    }

    public void selectGroup() {
        GroupItem item = this._groupMap.get(this._groupItem);
        if (item == null) {
            item = this._groupItem.allocateCopy();
            this._groupMap.put(item, item);
        }
        this._groupItem = item;
    }

    Iterator<GroupItem> groupResults() {
        if (this._groupMap == null) {
            return NullIterator.create();
        }
        Iterator<GroupItem> results = this._groupMap.values().iterator();
        this._groupMap = null;
        return results;
    }

    void setGroupItem(GroupItem item) {
        this._groupItem = item;
    }

    public TableIterator[] getTableIterators() {
        return this._tableIterators;
    }

    public void setTransaction(Transaction xa) {
        this._xa = xa;
    }

    public Transaction getTransaction() {
        return this._xa;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public int getRowUpdateCount() {
        return this._rowUpdateCount;
    }

    public void setRowUpdateCount(int count) {
        this._rowUpdateCount = count;
    }

    public boolean isReturnGeneratedKeys() {
        return this._isReturnGeneratedKeys;
    }

    public void setReturnGeneratedKeys(boolean isReturnGeneratedKeys) {
        this._isReturnGeneratedKeys = isReturnGeneratedKeys;
        if (this._isReturnGeneratedKeys && this._generatedKeys != null) {
            this._generatedKeys.init();
        }
    }

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public int getLimit() {
        return this._limit;
    }

    public boolean isGroupNull(int index) {
        return this._groupItem.isNull(index);
    }

    public void setGroupString(int index, String value) {
        this._groupItem.setString(index, value);
    }

    public String getGroupString(int index) {
        return this._groupItem.getString(index);
    }

    public void setGroupLong(int index, long value) {
        this._groupItem.setLong(index, value);
    }

    public long getGroupLong(int index) {
        return this._groupItem.getLong(index);
    }

    public void setGroupDouble(int index, double value) {
        this._groupItem.setDouble(index, value);
    }

    public double getGroupDouble(int index) {
        return this._groupItem.getDouble(index);
    }

    public Data getGroupData(int index) {
        return this._groupItem.getData(index);
    }

    public void setNull(int index) {
        this._parameters[index].setString(null);
    }

    public boolean isNull(int index) {
        return this._parameters[index].isNull();
    }

    public void setLong(int index, long value) {
        this._parameters[index].setLong(value);
    }

    public int getBoolean(int index) {
        return this._parameters[index].getBoolean();
    }

    public void setBoolean(int index, boolean value) {
        this._parameters[index].setBoolean(value);
    }

    public long getLong(int index) {
        return this._parameters[index].getLong();
    }

    public long getDate(int index) {
        return this._parameters[index].getDate();
    }

    public void setDouble(int index, double value) {
        this._parameters[index].setDouble(value);
    }

    public double getDouble(int index) {
        return this._parameters[index].getDouble();
    }

    public void setString(int index, String value) {
        this._parameters[index].setString(value);
    }

    public String getString(int index) {
        return this._parameters[index].getString();
    }

    public void setResult(SelectResult result) {
        this._result = result;
    }

    public SelectResult getResult() {
        return this._result;
    }

    public GeneratedKeysResultSet getGeneratedKeysResultSet() {
        if (!this._isReturnGeneratedKeys) {
            return null;
        }
        if (this._generatedKeys == null) {
            this._generatedKeys = new GeneratedKeysResultSet();
        }
        return this._generatedKeys;
    }

    public void lock() throws SQLException {
        if (this._isLocked) {
            throw new IllegalStateException(L.l("blocks are already locked"));
        }
        this._isLocked = true;
        int len = this._blockLocks.length;
        for (int i = 0; i < len; ++i) {
            Block bestBlock = null;
            long bestId = Long.MAX_VALUE;
            block1: for (int j = 0; j < len; ++j) {
                long id;
                Block block;
                TableIterator iter = this._tableIterators[j];
                if (iter == null || (block = iter.getBlock()) == null || bestId <= (id = block.getBlockId())) continue;
                for (int k = 0; k < i; ++k) {
                    if (this._blockLocks[k] == block) continue block1;
                }
                bestId = id;
                bestBlock = block;
            }
            this._blockLocks[i] = bestBlock;
            if (bestBlock == null) continue;
            if (this._isWrite) {
                this._xa.lockReadAndWrite(bestBlock.getLock());
                continue;
            }
            this._xa.lockRead(bestBlock.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws SQLException {
        if (!this._isLocked) {
            return;
        }
        this._isLocked = false;
        int len = this._blockLocks.length;
        for (int i = len - 1; i >= 0; --i) {
            Block block = this._blockLocks[i];
            if (block == null) continue;
            if (this._isWrite) {
                this._xa.unlockReadAndWrite(block.getLock());
                continue;
            }
            this._xa.unlockRead(block.getLock());
        }
        try {
            this._xa.writeData();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            for (int i = len - 1; i >= 0; --i) {
                Block block = this._blockLocks[i];
                this._blockLocks[i] = null;
                if (block == null || !this._isWrite) continue;
                try {
                    block.commit();
                    continue;
                }
                catch (IOException e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            throw throwable;
        }
        for (int i = len - 1; i >= 0; --i) {
            Block block = this._blockLocks[i];
            this._blockLocks[i] = null;
            if (block == null || !this._isWrite) continue;
            try {
                block.commit();
                continue;
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public static void free(QueryContext queryContext) {
        queryContext._groupMap = null;
        _freeList.free((Object)queryContext);
    }
}

