/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;

class RowIterateExpr
extends Expr {
    private static final Logger log = Log.open(RowIterateExpr.class);

    RowIterateExpr() {
    }

    boolean init(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.init(context);
        return this.nextBlock(context, rowIter);
    }

    boolean initRow(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.initRow();
        return rowIter.nextRow();
    }

    boolean nextRow(QueryContext context, TableIterator rowIter) throws IOException, SQLException {
        return rowIter.nextRow();
    }

    boolean allowChildRowShift(QueryContext context, TableIterator rowIter) {
        return true;
    }

    boolean nextBlock(QueryContext context, TableIterator rowIter) throws IOException, SQLException {
        context.unlock();
        while (rowIter.nextBlock()) {
            context.lock();
            rowIter.initRow();
            if (rowIter.nextRow()) {
                return true;
            }
            context.unlock();
        }
        return false;
    }
}

