/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectQuery;
import com.caucho.log.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubSelectParamExpr
extends Expr {
    private static final Logger log = Log.open(SubSelectParamExpr.class);
    private SelectQuery _subselect;
    private Expr _expr;
    private int _index;

    SubSelectParamExpr(Query subselect, Expr expr, int index) {
        this._subselect = (SelectQuery)subselect;
        this._expr = expr;
        this._index = index;
    }

    @Override
    public Class getType() {
        return this._expr.getType();
    }

    public Expr getExpr() {
        return this._expr;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._subselect.getSubSelect().cost(fromList) + 1L;
    }

    @Override
    public Expr bind(Query parent) throws SQLException {
        this._expr = this._expr.bind(parent);
        return this;
    }

    public void eval(QueryContext parent, QueryContext context) throws SQLException {
        Class type = this.getType();
        if (this._expr.isNull(parent)) {
            context.setNull(this._index);
        } else if (Long.TYPE.equals(type)) {
            context.setLong(this._index, this._expr.evalLong(parent));
        } else if (Integer.TYPE.equals(type)) {
            context.setLong(this._index, this._expr.evalLong(parent));
        } else {
            context.setString(this._index, this._expr.evalString(parent));
        }
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return context.isNull(this._index);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return context.getString(this._index);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        return context.getBoolean(this._index);
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        return context.getLong(this._index);
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return context.getDouble(this._index);
    }

    @Override
    public long evalDate(QueryContext context) throws SQLException {
        return context.getDate(this._index);
    }

    public String toString() {
        return "SubSelectParamExpr[" + this._expr + "]";
    }
}

