/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.UnboundIdentifierExpr;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnboundStarExpr
extends Expr {
    private static final L10N L = new L10N(UnboundStarExpr.class);
    private static final Logger log = Log.open(UnboundStarExpr.class);
    private final String _table;

    UnboundStarExpr() {
        this._table = null;
    }

    UnboundStarExpr(String tableName) {
        this._table = tableName;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        return this.bind(query.getFromItems());
    }

    protected Expr bind(FromItem[] fromItems) throws SQLException {
        return this;
    }

    protected ArrayList<Expr> expand(FromItem[] fromItems) throws SQLException {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (int i = 0; i < fromItems.length; ++i) {
            Table table = fromItems[i].getTable();
            Column[] columns = table.getColumns();
            if (this._table != null && !fromItems[i].getName().equals(this._table)) continue;
            for (int j = 0; j < columns.length; ++j) {
                exprs.add(new UnboundIdentifierExpr(fromItems[i].getName(), columns[j].getName()));
            }
        }
        return exprs;
    }

    public String toString() {
        return "UnboundStarExpr[]";
    }
}

