/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Block;
import com.caucho.db.store.WriteBlock;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoCommitWriteBlock
extends WriteBlock {
    private static final Logger log = Log.open(AutoCommitWriteBlock.class);
    private static final L10N L = new L10N(AutoCommitWriteBlock.class);

    public AutoCommitWriteBlock(Block block) throws IOException {
        super(block);
        Thread.dumpStack();
        block.read();
    }

    public byte[] getBuffer() {
        return this._block.getBuffer();
    }

    public void setDirty(int minDirty, int maxDirty) {
        this._block.setDirty(minDirty, maxDirty);
    }

    public void setFlushDirtyOnCommit(boolean flushOnCommit) {
        this._block.setFlushDirtyOnCommit(flushOnCommit);
    }

    public void commit() throws IOException {
        this._block.commit();
    }

    protected void freeImpl() {
        Block block;
        super.freeImpl();
        this._block = block = this._block;
        if (block != null) {
            try {
                block.commit();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
            block.free();
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return "AutoCommitWriteBlock[" + this.getStore() + "," + this.getBlockId() / 65536L + "]";
    }
}

