/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Block;
import com.caucho.db.store.ReadBlock;
import com.caucho.db.store.Store;
import com.caucho.log.Log;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.BlockManagerMXBean;
import com.caucho.util.L10N;
import com.caucho.util.LongKeyLruCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BlockManager
extends AbstractManagedObject
implements BlockManagerMXBean {
    private static final Logger log = Log.open(BlockManager.class);
    private static final L10N L = new L10N(BlockManager.class);
    private static BlockManager _staticManager;
    private final byte[] _storeMask = new byte[8192];
    private final LongKeyLruCache<Block> _blockCache;
    private final ArrayList<Block> _writeQueue = new ArrayList();
    private int _writeQueueMax = 32;

    private BlockManager(int capacity) {
        this._blockCache = new LongKeyLruCache(capacity);
        this._storeMask[0] = (byte)(this._storeMask[0] | 1);
        this.registerSelf();
        BlockManagerWriter writer = new BlockManagerWriter();
        Thread thread = new Thread((Runnable)writer, "resin-block-manager-writer");
        thread.setDaemon(true);
        thread.start();
    }

    public static synchronized BlockManager create(int minEntries) {
        if (_staticManager == null) {
            _staticManager = new BlockManager(minEntries);
        }
        _staticManager.ensureCapacity(minEntries);
        return _staticManager;
    }

    public static BlockManager getBlockManager() {
        return _staticManager;
    }

    public void ensureCapacity(int minCapacity) {
        this._blockCache.ensureCapacity(minCapacity);
    }

    public int allocateStoreId() {
        byte[] byArray = this._storeMask;
        synchronized (this._storeMask) {
            for (int i = 0; i < this._storeMask.length; ++i) {
                byte mask = this._storeMask[i];
                if (mask == 255) continue;
                for (int j = 0; j < 8; ++j) {
                    if ((mask & 1 << j) != 0) continue;
                    int n = i;
                    this._storeMask[n] = (byte)(this._storeMask[n] | 1 << j);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return 8 * i + j;
                }
            }
            throw new IllegalStateException(L.l("All store ids used."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Store store) {
        Block block;
        ArrayList<Block> dirtyBlocks = null;
        LongKeyLruCache<Block> longKeyLruCache = this._blockCache;
        synchronized (longKeyLruCache) {
            Iterator values = this._blockCache.values();
            while (values.hasNext()) {
                block = (Block)values.next();
                if (block == null || block.getStore() != store || !block.isDirty()) continue;
                if (dirtyBlocks == null) {
                    dirtyBlocks = new ArrayList<Block>();
                }
                dirtyBlocks.add(block);
            }
        }
        for (int i = 0; dirtyBlocks != null && i < dirtyBlocks.size(); ++i) {
            Block block2 = (Block)dirtyBlocks.get(i);
            try {
                block = block2;
                synchronized (block) {
                    block2.write();
                    continue;
                }
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeStore(Store store) {
        ArrayList<Block> removeBlocks = new ArrayList<Block>();
        Object object = this._blockCache;
        synchronized (object) {
            Iterator iter = this._blockCache.values();
            while (iter.hasNext()) {
                Block block = (Block)iter.next();
                if (block == null || block.getStore() != store) continue;
                removeBlocks.add(block);
            }
        }
        for (Block block : removeBlocks) {
            this._blockCache.remove(block.getBlockId());
        }
        object = this._writeQueue;
        synchronized (object) {
            while (this._writeQueue.size() > 0) {
                try {
                    this._writeQueue.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeStoreId(int storeId) {
        byte[] byArray = this._storeMask;
        synchronized (this._storeMask) {
            if (storeId <= 0) {
                throw new IllegalArgumentException(String.valueOf(storeId));
            }
            int n = storeId / 8;
            this._storeMask[n] = (byte)(this._storeMask[n] & ~(1 << storeId % 8));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block getBlock(Store store, long blockId) {
        Block block = (Block)this._blockCache.get(blockId);
        while (block == null || !block.allocate()) {
            Block dirtyBlock = null;
            ArrayList<Block> arrayList = this._writeQueue;
            synchronized (arrayList) {
                int size = this._writeQueue.size();
                for (int i = 0; !(i >= size || (dirtyBlock = this._writeQueue.get(i)).getBlockId() == blockId && dirtyBlock.allocate()); ++i) {
                    dirtyBlock = null;
                }
            }
            if ((blockId & 0xFFFFFFFFFFFF0000L) == 0L) {
                throw BlockManager.stateError(L.l("Block 0 is reserved."));
            }
            block = new ReadBlock(store, blockId);
            if (dirtyBlock != null) {
                byte[] dirtyBuffer = dirtyBlock.getBuffer();
                if (dirtyBuffer != null) {
                    System.arraycopy(dirtyBuffer, 0, block.getBuffer(), 0, dirtyBuffer.length);
                    block.validate();
                }
                dirtyBlock.free();
            }
            block = (Block)this._blockCache.putIfNew(blockId, (Object)block);
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLruDirtyWriteBlock(Block block) {
        ArrayList<Block> arrayList = this._writeQueue;
        synchronized (arrayList) {
            while (this._writeQueueMax < this._writeQueue.size()) {
                try {
                    this._writeQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this._writeQueue.add(block);
            this._writeQueue.notifyAll();
        }
    }

    public String getName() {
        return null;
    }

    public String getType() {
        return "BlockManager";
    }

    public long getBlockCapacity() {
        return this._blockCache.getCapacity();
    }

    public long getHitCountTotal() {
        return this._blockCache.getHitCount();
    }

    public long getMissCountTotal() {
        return this._blockCache.getMissCount();
    }

    private static IllegalStateException stateError(String msg) {
        IllegalStateException e = new IllegalStateException(msg);
        e.fillInStackTrace();
        log.log(Level.WARNING, e.toString(), e);
        return e;
    }

    static /* synthetic */ ArrayList access$000(BlockManager x0) {
        return x0._writeQueue;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    class BlockManagerWriter
    implements Runnable {
        BlockManagerWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block7: while (true) {
                try lbl-1000:
                // 2 sources

                {
                    while (true) {
                        block = null;
                        var2_4 = BlockManager.access$000(BlockManager.this);
                        synchronized (var2_4) {
                            while (true) lbl-1000:
                            // 4 sources

                            {
                                for (i = 0; i < BlockManager.access$000(BlockManager.this).size(); ++i) {
                                    block = (Block)BlockManager.access$000(BlockManager.this).get(i);
                                    if (block.isFree()) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 3, 7, 8, 9, 10, 13] lbl11 : MonitorExitStatement: MONITOREXIT : var2_4
                                        block.close();
                                        var2_4 = BlockManager.access$000(BlockManager.this);
                                        synchronized (var2_4) {
                                            break block7;
                                        }
                                    }
                                    block = null;
                                }
                                if (BlockManager.access$000(BlockManager.this).size() == 0) {
                                    BlockManager.access$000(BlockManager.this).wait();
                                    ** continue;
                                }
                                BlockManager.access$000(BlockManager.this).wait(10000L);
                            }
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (Throwable e) {
                    BlockManager.access$100().log(Level.WARNING, e.toString(), e);
                    continue;
                }
                break;
            }
            {
                for (i = 0; i < BlockManager.access$000(BlockManager.this).size(); ++i) {
                    if (block != BlockManager.access$000(BlockManager.this).get(i)) continue;
                    BlockManager.access$000(BlockManager.this).remove(i);
                    break;
                }
                BlockManager.access$000(BlockManager.this).notifyAll();
            }
            ** while (true)
        }
    }
}

