/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Inode;
import com.caucho.db.store.Store;
import java.io.IOException;
import java.io.Reader;

public class ClobReader
extends Reader {
    private static final int INODE_DIRECT_BLOCKS = 14;
    private Store _store;
    private long _length;
    private long _offset;
    private byte[] _inode;
    private int _inodeOffset;
    private long _lastOffset;
    private long _fragmentId;
    private char[] _buffer;

    public ClobReader(Store store, byte[] inode, int inodeOffset) {
        this.init(store, inode, inodeOffset);
    }

    public ClobReader(Inode inode) {
        this.init(inode.getStore(), inode.getBuffer(), 0);
    }

    public void init(Store store, byte[] inode, int inodeOffset) {
        if (store == null) {
            throw new NullPointerException();
        }
        this._store = store;
        this._inode = inode;
        this._inodeOffset = inodeOffset;
        this._length = ClobReader.readLong(inode, inodeOffset);
        this._offset = 0L;
        this._fragmentId = 0L;
        this._lastOffset = 0L;
    }

    public int read() throws IOException {
        int len;
        if (this._buffer == null) {
            this._buffer = new char[1];
        }
        if ((len = this.read(this._buffer, 0, 1)) < 0) {
            return -1;
        }
        return this._buffer[0];
    }

    public int read(char[] buf, int offset, int length) throws IOException {
        int sublen = Inode.read(this._inode, this._inodeOffset, this._store, this._offset, buf, offset, length);
        if (sublen > 0) {
            this._offset += (long)(2 * sublen);
        }
        return sublen;
    }

    public void close() {
    }

    public static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    private static int readShort(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 8) + (buffer[offset + 1] & 0xFF);
    }
}

