/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.BlobInputStream;
import com.caucho.db.store.BlobOutputStream;
import com.caucho.db.store.Block;
import com.caucho.db.store.ClobReader;
import com.caucho.db.store.ClobWriter;
import com.caucho.db.store.RawTransaction;
import com.caucho.db.store.Store;
import com.caucho.db.store.StoreTransaction;
import com.caucho.util.L10N;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.TempCharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Inode {
    private static final L10N L = new L10N(Inode.class);
    private static final Logger log = Logger.getLogger(Inode.class.getName());
    public static final int INODE_SIZE = 128;
    public static final int INLINE_BLOB_SIZE = 120;
    public static final int BLOCK_SIZE = 65536;
    public static final int INODE_BLOCK_SIZE = 8192;
    public static final int FRAGMENT_SIZE = 8192;
    public static final int MINI_FRAG_SIZE = 256;
    public static final int MINI_FRAG_BLOB_SIZE = 3840;
    public static final int INDIRECT_BLOCKS = 1024;
    public static final int DIRECT_BLOCKS = 14;
    public static final int SINGLE_INDIRECT_BLOCKS = 512;
    public static final int DOUBLE_INDIRECT_BLOCKS = 256;
    public static final int TRIPLE_INDIRECT_BLOCKS = 256;
    public static final long INLINE_MAX = 120L;
    public static final int MINI_FRAG_MAX = 3840;
    public static final long DIRECT_MAX = 114688L;
    public static final long SINGLE_INDIRECT_MAX = 4308992L;
    public static final long FRAGMENT_MAX = 4308992L;
    public static final long DOUBLE_INDIRECT_MAX = 137443262464L;
    private static final byte[] NULL_BYTES = new byte[128];
    private Store _store;
    private StoreTransaction _xa;
    private byte[] _bytes = new byte[128];

    public Inode() {
    }

    public Inode(Store store, StoreTransaction xa) {
        this._store = store;
        this._xa = xa;
    }

    public Inode(Store store) {
        this(store, RawTransaction.create());
    }

    public Store getStore() {
        return this._store;
    }

    public byte[] getBuffer() {
        return this._bytes;
    }

    public long getLength() {
        return Inode.readLong(this._bytes, 0);
    }

    public void init(Store store, StoreTransaction xa, byte[] buffer, int offset) {
        this._store = store;
        this._xa = xa;
        System.arraycopy(buffer, offset, this._bytes, 0, this._bytes.length);
    }

    public InputStream openInputStream() {
        return new BlobInputStream(this);
    }

    public void writeToStream(OutputStreamWithBuffer os) throws IOException {
        this.writeToStream(os, 0L, 0x3FFFFFFFFFFFFFFFL);
    }

    public void writeToStream(OutputStreamWithBuffer os, long offset, long length) throws IOException {
        byte[] buffer = os.getBuffer();
        int writeLength = buffer.length;
        int writeOffset = os.getBufferOffset();
        while (length > 0L) {
            int len;
            int sublen = writeLength - writeOffset;
            if (sublen == 0) {
                buffer = os.nextBuffer(writeOffset);
                writeOffset = os.getBufferOffset();
                sublen = writeLength - writeOffset;
            }
            if (length < (long)sublen) {
                sublen = (int)length;
            }
            if ((len = Inode.read(this._bytes, 0, this._store, offset, buffer, writeOffset, sublen)) <= 0) break;
            writeOffset += len;
            offset += (long)len;
            length -= (long)len;
        }
        os.setBufferOffset(writeOffset);
    }

    public void writeToWriter(Writer writer) throws IOException {
        int sublen;
        int len;
        TempCharBuffer tempBuffer = TempCharBuffer.allocate();
        char[] buffer = tempBuffer.getBuffer();
        int writeLength = buffer.length;
        long offset = 0L;
        while ((len = Inode.read(this._bytes, 0, this._store, offset, buffer, 0, sublen = writeLength)) > 0) {
            writer.write(buffer, 0, len);
            offset += (long)(2 * len);
        }
        TempCharBuffer.free((TempCharBuffer)tempBuffer);
    }

    static int read(byte[] inode, int inodeOffset, Store store, long fileOffset, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int sublen;
        long fileLength = Inode.readLong(inode, inodeOffset);
        if (fileLength - fileOffset < (long)(sublen = bufferLength)) {
            sublen = (int)(fileLength - fileOffset);
        }
        if (sublen <= 0) {
            return -1;
        }
        if (fileLength <= 120L) {
            System.arraycopy(inode, inodeOffset + 8 + (int)fileOffset, buffer, bufferOffset, sublen);
            return sublen;
        }
        if (fileLength <= 3840L) {
            long fragAddr = Inode.readMiniFragAddr(inode, inodeOffset, store, fileOffset);
            int fragOffset = (int)(fileOffset % 256L);
            if (256 - fragOffset < sublen) {
                sublen = 256 - fragOffset;
            }
            store.readMiniFragment(fragAddr, fragOffset, buffer, bufferOffset, sublen);
            return sublen;
        }
        if (fileOffset < 4308992L) {
            long fragAddr = Inode.readFragmentAddr(inode, inodeOffset, store, fileOffset);
            int fragOffset = (int)(fileOffset % 8192L);
            if (8192 - fragOffset < sublen) {
                sublen = 8192 - fragOffset;
            }
            store.readFragment(fragAddr, fragOffset, buffer, bufferOffset, sublen);
            return sublen;
        }
        long addr = Inode.readBlockAddr(inode, inodeOffset, store, fileOffset);
        int offset = (int)((fileOffset - 4308992L) % 65536L);
        if (65536 - offset < sublen) {
            sublen = 65536 - offset;
        }
        store.readBlock(addr, offset, buffer, bufferOffset, sublen);
        return sublen;
    }

    static void append(byte[] inode, int inodeOffset, Store store, StoreTransaction xa, byte[] buffer, int offset, int length) throws IOException {
        long currentLength = Inode.readLong(inode, inodeOffset);
        long newLength = currentLength + (long)length;
        Inode.writeLong(inode, inodeOffset, newLength);
        if (newLength <= 120L) {
            System.arraycopy(buffer, offset, inode, (int)((long)(inodeOffset + 8) + currentLength), length);
        } else if (newLength <= 3840L) {
            while (length > 0) {
                long miniFragAddr;
                int sublen = length;
                if (256 < sublen) {
                    sublen = 256;
                }
                if ((miniFragAddr = store.allocateMiniFragment(xa)) == 0L) {
                    throw new IllegalStateException(L.l("illegal mini fragment"));
                }
                Inode.writeMiniFragAddr(inode, inodeOffset, store, xa, currentLength, miniFragAddr);
                store.writeMiniFragment(xa, miniFragAddr, 0, buffer, offset, sublen);
                offset += sublen;
                length -= sublen;
                currentLength += (long)sublen;
            }
        } else {
            if (currentLength < 4308992L) {
                int sublen = length;
                if (4308992L - currentLength < (long)sublen) {
                    sublen = (int)(4308992L - currentLength);
                }
                Inode.appendFragment(inode, inodeOffset, store, xa, buffer, offset, length, currentLength);
                offset += sublen;
                length -= sublen;
                currentLength += (long)sublen;
            }
            if (length > 0) {
                Inode.appendBlock(inode, inodeOffset, store, xa, buffer, offset, length, currentLength);
            }
        }
    }

    private static void appendFragment(byte[] inode, int inodeOffset, Store store, StoreTransaction xa, byte[] buffer, int offset, int length, long currentLength) throws IOException {
        while (length > 0 && currentLength < 4308992L) {
            long fragAddr;
            if (currentLength % 8192L != 0L) {
                long fragAddr2 = Inode.readFragmentAddr(inode, inodeOffset, store, currentLength);
                if (fragAddr2 == 0L) {
                    throw new IllegalStateException("inode: illegal fragment at " + currentLength);
                }
                int fragOffset = (int)(currentLength % 8192L);
                int sublen = length;
                if (8192 - fragOffset < sublen) {
                    sublen = 8192 - fragOffset;
                }
                store.writeFragment(xa, fragAddr2, fragOffset, buffer, offset, sublen);
                offset += sublen;
                length -= sublen;
                currentLength += (long)sublen;
                continue;
            }
            int sublen = length;
            if (8192 < sublen) {
                sublen = 8192;
            }
            if ((fragAddr = store.allocateFragment(xa)) == 0L) {
                throw new IllegalStateException(L.l("illegal fragment"));
            }
            Inode.writeFragmentAddr(inode, inodeOffset, store, xa, currentLength, fragAddr);
            store.writeFragment(xa, fragAddr, 0, buffer, offset, sublen);
            offset += sublen;
            length -= sublen;
            currentLength += (long)sublen;
        }
    }

    private static void appendBlock(byte[] inode, int inodeOffset, Store store, StoreTransaction xa, byte[] buffer, int offset, int length, long currentLength) throws IOException {
        while (length > 0) {
            if ((currentLength - 4308992L) % 65536L != 0L) {
                long addr = Inode.readBlockAddr(inode, inodeOffset, store, currentLength);
                if (addr == 0L) {
                    throw new IllegalStateException("inode: illegal block at " + currentLength);
                }
                int blockOffset = (int)((currentLength - 4308992L) % 65536L);
                int sublen = length;
                if (65536 - blockOffset < sublen) {
                    sublen = 65536 - blockOffset;
                }
                store.writeBlock(xa, addr, blockOffset, buffer, offset, sublen);
                offset += sublen;
                length -= sublen;
                currentLength += (long)sublen;
                continue;
            }
            int sublen = length;
            if (65536 < sublen) {
                sublen = 65536;
            }
            Block block = store.allocateBlock();
            long blockAddr = Store.blockIdToAddress(block.getBlockId());
            block.free();
            if (blockAddr == 0L) {
                throw new IllegalStateException(L.l("illegal block"));
            }
            Inode.writeBlockAddr(inode, inodeOffset, store, xa, currentLength, blockAddr);
            store.writeBlock(xa, blockAddr, 0, buffer, offset, sublen);
            offset += sublen;
            length -= sublen;
            currentLength += (long)sublen;
        }
    }

    static int read(byte[] inode, int inodeOffset, Store store, long fileOffset, char[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long fileLength = Inode.readLong(inode, inodeOffset);
        int sublen = (int)(fileLength - fileOffset) / 2;
        if (bufferLength < sublen) {
            sublen = bufferLength;
        }
        if (sublen <= 0) {
            return -1;
        }
        if (fileLength <= 120L) {
            int baseOffset = inodeOffset + 8 + (int)fileOffset;
            for (int i = 0; i < sublen; ++i) {
                char ch;
                buffer[bufferOffset + i] = ch = (char)(((inode[baseOffset] & 0xFF) << 8) + (inode[baseOffset + 1] & 0xFF));
                baseOffset += 2;
            }
            return sublen;
        }
        if (fileLength <= 3840L) {
            long fragAddr = Inode.readMiniFragAddr(inode, inodeOffset, store, fileOffset);
            int fragOffset = (int)(fileOffset % 256L);
            if (256 - fragOffset < 2 * sublen) {
                sublen = (256 - fragOffset) / 2;
            }
            store.readMiniFragment(fragAddr, fragOffset, buffer, bufferOffset, sublen);
            return sublen;
        }
        if (fileOffset < 4308992L) {
            long fragAddr = Inode.readFragmentAddr(inode, inodeOffset, store, fileOffset);
            int fragOffset = (int)(fileOffset % 8192L);
            if (8192 - fragOffset < 2 * sublen) {
                sublen = (8192 - fragOffset) / 2;
            }
            store.readFragment(fragAddr, fragOffset, buffer, bufferOffset, sublen);
            return sublen;
        }
        long addr = Inode.readBlockAddr(inode, inodeOffset, store, fileOffset);
        int offset = (int)((fileOffset - 4308992L) % 65536L);
        if (65536 - offset < sublen) {
            sublen = 65536 - offset;
        }
        store.readBlock(addr, offset, buffer, bufferOffset, sublen);
        return sublen;
    }

    static void append(byte[] inode, int inodeOffset, Store store, StoreTransaction xa, char[] buffer, int offset, int length) throws IOException {
        long currentLength = Inode.readLong(inode, inodeOffset);
        long newLength = currentLength + (long)length;
        Inode.writeLong(inode, inodeOffset, newLength);
        if (newLength <= 120L) {
            int writeOffset = (int)((long)(inodeOffset + 8) + currentLength);
            for (int i = 0; i < length; ++i) {
                char ch = buffer[offset + i];
                inode[writeOffset++] = (byte)(ch >> 8);
                inode[writeOffset++] = (byte)ch;
            }
        } else {
            if (currentLength % 8192L != 0L) {
                long fragAddr = Inode.readFragmentAddr(inode, inodeOffset, store, currentLength);
                int fragOffset = (int)(currentLength % 8192L);
                int sublen = 2 * length;
                if (8192 - fragOffset < sublen) {
                    sublen = 8192 - fragOffset;
                }
                store.writeFragment(xa, fragAddr, fragOffset, buffer, offset, sublen);
                offset += sublen / 2;
                length -= sublen / 2;
                currentLength += (long)sublen;
            }
            while (length > 0) {
                int sublen = 2 * length;
                if (8192 < sublen) {
                    sublen = 8192;
                }
                long fragAddr = store.allocateFragment(xa);
                Inode.writeFragmentAddr(inode, inodeOffset, store, xa, currentLength, fragAddr);
                store.writeFragment(xa, fragAddr, 0, buffer, offset, sublen);
                offset += sublen / 2;
                length -= sublen / 2;
                currentLength += (long)sublen;
            }
        }
    }

    private void appendFragment(byte[] inode, int inodeOffset, Store store, StoreTransaction xa, char[] buffer, int offset, int length, long currentLength) throws IOException {
        while (length > 0 && currentLength < 4308992L) {
            long fragAddr;
            if (currentLength % 8192L != 0L) {
                long fragAddr2 = Inode.readFragmentAddr(inode, inodeOffset, store, currentLength);
                if (fragAddr2 == 0L) {
                    throw new IllegalStateException("inode: illegal fragment at " + currentLength);
                }
                int fragOffset = (int)(currentLength % 8192L);
                int sublen = 2 * length;
                if (8192 - fragOffset < sublen) {
                    sublen = 8192 - fragOffset;
                }
                store.writeFragment(xa, fragAddr2, fragOffset, buffer, offset, sublen);
                offset += sublen / 2;
                length -= sublen / 2;
                currentLength += (long)sublen;
                continue;
            }
            int sublen = 2 * length;
            if (8192 < sublen) {
                sublen = 8192;
            }
            if ((fragAddr = store.allocateFragment(xa)) == 0L) {
                throw new IllegalStateException(L.l("illegal fragment"));
            }
            Inode.writeFragmentAddr(inode, inodeOffset, store, xa, currentLength, fragAddr);
            store.writeFragment(xa, fragAddr, 0, buffer, offset, sublen);
            offset += sublen / 2;
            length -= sublen / 2;
            currentLength += (long)sublen;
        }
    }

    private void appendBlock(byte[] inode, int inodeOffset, Store store, StoreTransaction xa, char[] buffer, int offset, int length, long currentLength) throws IOException {
        while (length > 0) {
            long blockAddr;
            if ((currentLength - 4308992L) % 65536L != 0L) {
                long addr = Inode.readBlockAddr(inode, inodeOffset, store, currentLength);
                if (addr == 0L) {
                    throw new IllegalStateException("inode: illegal block at " + currentLength);
                }
                int blockOffset = (int)((currentLength - 4308992L) % 65536L);
                int sublen = 2 * length;
                if (65536 - blockOffset < sublen) {
                    sublen = 65536 - blockOffset;
                }
                store.writeBlock(xa, addr, blockOffset, buffer, offset, sublen);
                offset += sublen / 2;
                length -= sublen / 2;
                currentLength += (long)sublen;
                continue;
            }
            int sublen = 2 * length;
            if (65536 < sublen) {
                sublen = 65536;
            }
            if ((blockAddr = store.allocateFragment(xa)) == 0L) {
                throw new IllegalStateException(L.l("illegal fragment"));
            }
            Inode.writeBlockAddr(inode, inodeOffset, store, xa, currentLength, blockAddr);
            store.writeBlock(xa, blockAddr, 0, buffer, offset, sublen);
            offset += sublen / 2;
            length -= sublen / 2;
            currentLength += (long)sublen;
        }
    }

    public OutputStream openOutputStream() {
        return new BlobOutputStream(this);
    }

    void closeOutputStream() {
        try {
            this._store.saveAllocation();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public Reader openReader() {
        return new ClobReader(this);
    }

    public Writer openWriter() {
        return new ClobWriter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove() {
        var1_1 = this._bytes;
        synchronized (this._bytes) {
            block24: {
                block27: {
                    block23: {
                        bytes = this._bytes;
                        try {
                            try {
                                block26: {
                                    block25: {
                                        if (length <= 120L) break block25;
                                        if (bytes != null) break block26;
                                    }
                                    var13_4 = null;
                                    break block23;
                                }
                                if (length <= 3840L) {
                                    for (length = Inode.readLong(this._bytes, 0); length > 0L; length -= 256L) {
                                        fragAddr = Inode.readMiniFragAddr(bytes, 0, this._store, length - 1L);
                                        if ((fragAddr & -65536L) == 0L) {
                                            msg = this._store + ": inode block " + Long.toHexString(length) + " has 0 fragment";
                                            throw Inode.stateError(msg);
                                        }
                                        if (fragAddr < 0L) {
                                            msg = this._store + ": inode block " + Long.toHexString(length) + " has invalid fragment " + Long.toHexString(fragAddr);
                                            throw Inode.stateError(msg);
                                        }
                                        this._store.deleteMiniFragment(this._xa, fragAddr);
                                    }
                                } else {
                                    initLength = length;
                                    while (length > 0L) {
                                        fragAddr = Inode.readFragmentAddr(bytes, 0, this._store, length - 1L);
                                        if ((fragAddr & -65536L) == 0L) {
                                            msg = this._store + ": inode block " + Long.toHexString(length) + " has 0 fragment";
                                            throw Inode.stateError(msg);
                                        }
                                        if (fragAddr < 0L) {
                                            msg = this._store + ": inode block " + Long.toHexString(length) + " has invalid fragment " + Long.toHexString(fragAddr);
                                            throw Inode.stateError(msg);
                                        }
                                        this._store.deleteFragment(this._xa, fragAddr);
                                        fragCount = (int)((length - 1L) / 8192L);
                                        dblFragCount = fragCount - 14 - 512;
                                        if (dblFragCount >= 0 && dblFragCount % 1024 == 0) {
                                            fragAddr = Inode.readLong(bytes, 120);
                                            dblIndex = 8 * (fragCount / 1024);
                                            if ((fragAddr = this._store.readFragmentLong(fragAddr, dblIndex)) != 0L) {
                                                this._store.deleteFragment(this._xa, fragAddr);
                                            }
                                        }
                                        if (fragCount == 14 && (fragAddr = Inode.readLong(bytes, 120)) != 0L) {
                                            this._store.deleteFragment(this._xa, fragAddr);
                                        }
                                        length -= 8192L;
                                    }
                                }
                                var13_5 = null;
                            }
                            catch (Throwable e) {
                                Inode.log.log(Level.WARNING, e.toString(), e);
                                var13_6 = null;
                                System.arraycopy(Inode.NULL_BYTES, 0, this._bytes, 0, Inode.NULL_BYTES.length);
                                ** try [egrp 3[TRYBLOCK] [6 : 538->548)] { 
lbl53:
                                // 1 sources

                                this._store.saveAllocation();
lbl55:
                                // 1 sources

                                catch (Throwable e) {
                                    Inode.log.log(Level.FINE, e.toString(), e);
                                }
                                break block24;
                            }
                            System.arraycopy(Inode.NULL_BYTES, 0, this._bytes, 0, Inode.NULL_BYTES.length);
                            try {
                                this._store.saveAllocation();
                            }
                            catch (Throwable e) {
                                Inode.log.log(Level.FINE, e.toString(), e);
                            }
                            break block24;
                        }
                        catch (Throwable var12_23) {
                            var13_7 = null;
                            System.arraycopy(Inode.NULL_BYTES, 0, this._bytes, 0, Inode.NULL_BYTES.length);
                            ** try [egrp 3[TRYBLOCK] [6 : 538->548)] { 
lbl70:
                            // 1 sources

                            this._store.saveAllocation();
                            throw var12_23;
lbl72:
                            // 1 sources

                            catch (Throwable e) {
                                Inode.log.log(Level.FINE, e.toString(), e);
                            }
                            throw var12_23;
                        }
                    }
                    System.arraycopy(Inode.NULL_BYTES, 0, this._bytes, 0, Inode.NULL_BYTES.length);
                    ** try [egrp 3[TRYBLOCK] [6 : 538->548)] { 
lbl78:
                    // 1 sources

                    this._store.saveAllocation();
                    break block27;
lbl80:
                    // 1 sources

                    catch (Throwable e) {
                        Inode.log.log(Level.FINE, e.toString(), e);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static void clear(byte[] inode, int inodeOffset) {
        int end = inodeOffset + 128;
        while (inodeOffset < end) {
            inode[inodeOffset] = 0;
            ++inodeOffset;
        }
    }

    static long readMiniFragAddr(byte[] inode, int inodeOffset, Store store, long fileOffset) throws IOException {
        long fragCount = fileOffset / 256L;
        return Inode.readLong(inode, (int)((long)(inodeOffset + 8) + 8L * fragCount));
    }

    private static void writeMiniFragAddr(byte[] inode, int offset, Store store, StoreTransaction xa, long fragLength, long fragAddr) throws IOException {
        int fragCount = (int)(fragLength / 256L);
        if ((fragAddr & 0xFFFFFFFFFFFF0000L) == 0L) {
            throw new IllegalStateException(store + ": inode block " + fragLength + " has zero value " + fragAddr);
        }
        Inode.writeLong(inode, offset + (fragCount + 1) * 8, fragAddr);
    }

    static long readFragmentAddr(byte[] inode, int inodeOffset, Store store, long fileOffset) throws IOException {
        long fragCount = fileOffset / 8192L;
        if (fragCount < 14L) {
            return Inode.readLong(inode, (int)((long)(inodeOffset + 8) + 8L * fragCount));
        }
        if (fragCount < 526L) {
            long indirectAddr = Inode.readLong(inode, inodeOffset + 120);
            if (indirectAddr == 0L) {
                throw new IllegalStateException(L.l("null block id"));
            }
            int offset = (int)(8L * (fragCount - 14L));
            long fragAddr = store.readFragmentLong(indirectAddr, offset);
            return fragAddr;
        }
        if (fragCount < 262670L) {
            long indirectAddr = Inode.readLong(inode, inodeOffset + 120);
            if (indirectAddr == 0L) {
                throw new IllegalStateException(L.l("null block id"));
            }
            int index = (int)(8L * ((fragCount -= 526L) / 1024L));
            long doubleIndirectAddr = store.readFragmentLong(indirectAddr, index);
            int offset = (int)(8L * (fragCount % 1024L));
            return store.readFragmentLong(doubleIndirectAddr, offset);
        }
        throw new IllegalStateException(L.l("Can't yet support data over 64M"));
    }

    private static void writeFragmentAddr(byte[] inode, int offset, Store store, StoreTransaction xa, long fragLength, long fragAddr) throws IOException {
        int fragCount = (int)(fragLength / 8192L);
        if ((fragAddr & 0xFFFFFFFFFFFF0000L) == 0L) {
            String msg = store + ": inode block " + fragCount + " writing 0 fragment";
            throw Inode.stateError(msg);
        }
        if (fragCount < 14) {
            Inode.writeLong(inode, offset + (fragCount + 1) * 8, fragAddr);
        } else if (fragCount < 526) {
            long indAddr = Inode.readLong(inode, offset + 120);
            if (indAddr == 0L) {
                indAddr = store.allocateFragment(xa);
                Inode.writeLong(inode, offset + 120, indAddr);
            }
            int fragOffset = 8 * (fragCount - 14);
            store.writeFragmentLong(xa, indAddr, fragOffset, fragAddr);
        } else if (fragCount < 262670) {
            int count;
            int dblIndCount;
            long dblIndAddr;
            long indAddr = Inode.readLong(inode, offset + 120);
            if (indAddr == 0L) {
                indAddr = store.allocateFragment(xa);
                Inode.writeLong(inode, offset + 120, indAddr);
            }
            if ((dblIndAddr = store.readFragmentLong(indAddr, (dblIndCount = (count = fragCount - 14 - 512) / 1024) * 8)) == 0L) {
                dblIndAddr = store.allocateFragment(xa);
                store.writeFragmentLong(xa, indAddr, dblIndCount * 8, dblIndAddr);
            }
            int fragOffset = 8 * (count % 1024);
            store.writeFragmentLong(xa, dblIndAddr, fragOffset, fragAddr);
        } else {
            throw new IllegalStateException(L.l("Can't yet support data over 64M"));
        }
    }

    static long readBlockAddr(byte[] inode, int inodeOffset, Store store, long fileOffset) throws IOException {
        if (fileOffset < 4308992L) {
            throw new IllegalStateException("block/fragment mixup");
        }
        if (fileOffset < 137443262464L) {
            long indAddr = Inode.readLong(inode, inodeOffset + 120);
            if (indAddr == 0L) {
                throw new IllegalStateException(L.l("{0} null block id", (Object)store));
            }
            int blockCount = (int)((fileOffset - 4308992L) / 65536L);
            int dblBlockCount = blockCount / 8192;
            int dblBlockIndex = 8 * (512 + dblBlockCount);
            long dblIndAddr = store.readFragmentLong(indAddr, dblBlockIndex);
            if (dblIndAddr == 0L) {
                throw new IllegalStateException(L.l("null indirect block id"));
            }
            int blockOffset = 8 * (blockCount % 8192);
            return store.readBlockLong(dblIndAddr, blockOffset);
        }
        throw new IllegalStateException(L.l("size over {0}M not supported", 131076L));
    }

    private static void writeBlockAddr(byte[] inode, int inodeOffset, Store store, StoreTransaction xa, long fileOffset, long blockAddr) throws IOException {
        long dblIndAddr;
        int blockCount;
        if (fileOffset < 4308992L) {
            throw new IllegalStateException("block/fragment mixup");
        }
        if (fileOffset < 137443262464L) {
            long indAddr = Inode.readLong(inode, inodeOffset + 120);
            if (indAddr == 0L) {
                throw new IllegalStateException(L.l("{0} null block id", (Object)store));
            }
            blockCount = (int)((fileOffset - 4308992L) / 65536L);
            int dblBlockCount = blockCount / 8192;
            int dblBlockIndex = 8 * (512 + dblBlockCount);
            dblIndAddr = store.readFragmentLong(indAddr, dblBlockIndex);
            if (dblIndAddr == 0L) {
                Block block = store.allocateBlock();
                dblIndAddr = Store.blockIdToAddress(block.getBlockId());
                block.free();
                store.writeFragmentLong(xa, indAddr, dblBlockIndex, dblIndAddr);
            }
        } else {
            throw new IllegalStateException(L.l("size over {0}M not supported", 131076L));
        }
        int blockOffset = 8 * (blockCount % 8192);
        store.writeBlockLong(xa, dblIndAddr, blockOffset, blockAddr);
    }

    public static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    public static void writeLong(byte[] buffer, int offset, long v) {
        buffer[offset + 0] = (byte)(v >> 56);
        buffer[offset + 1] = (byte)(v >> 48);
        buffer[offset + 2] = (byte)(v >> 40);
        buffer[offset + 3] = (byte)(v >> 32);
        buffer[offset + 4] = (byte)(v >> 24);
        buffer[offset + 5] = (byte)(v >> 16);
        buffer[offset + 6] = (byte)(v >> 8);
        buffer[offset + 7] = (byte)v;
    }

    private static int readShort(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 8) + (buffer[offset + 1] & 0xFF);
    }

    private static void writeShort(byte[] buffer, int offset, int v) {
        buffer[offset + 0] = (byte)(v >> 8);
        buffer[offset + 1] = (byte)v;
    }

    private static IllegalStateException stateError(String msg) {
        IllegalStateException e = new IllegalStateException(msg);
        e.fillInStackTrace();
        log.log(Level.WARNING, e.toString(), e);
        return e;
    }
}

