/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.LockTimeoutException;
import com.caucho.db.store.Transaction;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Lock {
    private static final L10N L = new L10N(Lock.class);
    private static final Logger log = Log.open(Lock.class);
    private final String _id;
    private int _tryUpgradeCount;
    private int _tryWriteCount;
    private int _readCount;
    private boolean _isWrite;
    private Thread _owner;

    public Lock(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    void lockRead(Transaction xa, long timeout) throws LockTimeoutException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " lockRead (read:" + this._readCount + " write:" + this._isWrite + " try-write:" + this._tryWriteCount + ")");
        }
        long start = Alarm.getCurrentTime();
        long expire = start + timeout;
        Lock lock = this;
        synchronized (lock) {
            while (true) {
                if (!this._isWrite && this._tryWriteCount == 0) {
                    ++this._readCount;
                    return;
                }
                long delta = expire - Alarm.getCurrentTime();
                if (delta < 0L || Alarm.isTest()) break;
                try {
                    this.wait(delta);
                }
                catch (InterruptedException e) {
                    throw new LockTimeoutException(e);
                }
            }
            if (!Alarm.isTest()) {
                this.printOwnerStack();
                Thread.dumpStack();
            }
            throw new LockTimeoutException(L.l("{0} lockRead timed out ({1}ms) read-count:{2} try-writers:{3} is-write:{4}", (Object)this, (Object)(Alarm.getCurrentTime() - start), (Object)this._readCount, (Object)this._tryWriteCount, (Object)this._isWrite));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockRead() throws SQLException {
        Lock lock = this;
        synchronized (lock) {
            --this._readCount;
            if (this._readCount < 0) {
                Thread.dumpStack();
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this + " unlockRead (read:" + this._readCount + " write:" + this._isWrite + " try-write:" + this._tryWriteCount + ")");
            }
            this.notifyAll();
        }
    }

    void lockReadAndWrite(Transaction xa, long timeout) throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " lockReadAndWrite (read:" + this._readCount + " write:" + this._isWrite + " try-write:" + this._tryWriteCount + ")");
        }
        long start = Alarm.getCurrentTime();
        long expire = start + timeout;
        boolean isOkay = false;
        Lock lock = this;
        synchronized (lock) {
            ++this._tryWriteCount;
            if (this._owner == null) {
                this._owner = Thread.currentThread();
            }
            try {
                while (true) {
                    if (!this._isWrite && this._readCount == this._tryUpgradeCount) {
                        ++this._readCount;
                        this._isWrite = true;
                        this._owner = Thread.currentThread();
                        Object var14_8 = null;
                        --this._tryWriteCount;
                        this.notifyAll();
                        return;
                    }
                    long delta = expire - Alarm.getCurrentTime();
                    if (delta < 0L || Alarm.isTest()) break;
                    try {
                        this.wait(delta);
                    }
                    catch (InterruptedException e) {
                        throw new LockTimeoutException(e);
                    }
                }
                if (!Alarm.isTest()) {
                    this.printOwnerStack();
                    Thread.dumpStack();
                }
                throw new LockTimeoutException(L.l("{0} lockReadAndWrite timed out ({1}ms) readers:{2} is-write:{3} try-writers:{4} try-upgrade:{5}", (Object)this, (Object)(Alarm.getCurrentTime() - start), (Object)this._readCount, (Object)this._isWrite, (Object)this._tryWriteCount, (Object)this._tryUpgradeCount));
            }
            catch (Throwable throwable) {
                Object var14_9 = null;
                --this._tryWriteCount;
                this.notifyAll();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockReadAndWriteNoWait() throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " lockReadAndWriteNoWait (read:" + this._readCount + " write:" + this._isWrite + " try-write:" + this._tryWriteCount + ")");
        }
        Lock lock = this;
        synchronized (lock) {
            if (this._owner == null) {
                this._owner = Thread.currentThread();
            }
            if (this._readCount == 0 && !this._isWrite) {
                this._owner = Thread.currentThread();
                ++this._readCount;
                this._isWrite = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockReadAndWrite() throws SQLException {
        Lock lock = this;
        synchronized (lock) {
            --this._readCount;
            this._isWrite = false;
            this._owner = null;
            this.notifyAll();
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " unlockReadAndWrite (read:" + this._readCount + " write:" + this._isWrite + " try-write:" + this._tryWriteCount + ")");
        }
    }

    void lockWrite(Transaction xa, long timeout) throws SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " lockWrite (read:" + this._readCount + " write:" + this._isWrite + " try-write:" + this._tryWriteCount + ")");
        }
        long start = Alarm.getCurrentTime();
        long expire = start + timeout;
        Lock lock = this;
        synchronized (lock) {
            ++this._tryWriteCount;
            ++this._tryUpgradeCount;
            if (this._owner == null) {
                this._owner = Thread.currentThread();
            }
            try {
                while (true) {
                    if (!this._isWrite && this._readCount == this._tryUpgradeCount) {
                        this._isWrite = true;
                        this._owner = Thread.currentThread();
                        Object var13_7 = null;
                        --this._tryWriteCount;
                        --this._tryUpgradeCount;
                        this.notifyAll();
                        return;
                    }
                    long delta = expire - Alarm.getCurrentTime();
                    if (delta < 0L || Alarm.isTest()) break;
                    try {
                        this.wait(delta);
                    }
                    catch (InterruptedException e) {
                        throw new LockTimeoutException(e);
                    }
                }
                if (!Alarm.isTest()) {
                    this.printOwnerStack();
                    Thread.dumpStack();
                }
                throw new LockTimeoutException(L.l("{0} lockWrite timed out ({1}ms) readers:{2} try-writers:{3} upgrade:{4}", (Object)this, (Object)(Alarm.getCurrentTime() - start), (Object)this._readCount, (Object)this._tryWriteCount, (Object)this._tryUpgradeCount));
            }
            catch (Throwable throwable) {
                Object var13_8 = null;
                --this._tryWriteCount;
                --this._tryUpgradeCount;
                this.notifyAll();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockWrite() throws SQLException {
        Lock lock = this;
        synchronized (lock) {
            this._isWrite = false;
            this._owner = null;
            this.notifyAll();
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " unlockWrite (read:" + this._readCount + " write:" + this._isWrite + " try-write:" + this._tryWriteCount + ")");
        }
    }

    void waitForCommit() {
        Thread.yield();
        Lock lock = this;
        synchronized (lock) {
            while (true) {
                if (!this._isWrite && this._tryWriteCount == 0) {
                    return;
                }
                if (Alarm.isTest()) {
                    return;
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
    }

    private void printOwnerStack() {
        Thread thread = this._owner;
        if (thread == null) {
            return;
        }
        System.out.println("Owner-stack");
        StackTraceElement[] stack = thread.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            System.out.println(stack[i]);
        }
    }

    public String toString() {
        return "Lock[" + this._id + "]";
    }
}

