/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.Database;
import com.caucho.db.store.Block;
import com.caucho.db.store.BlockManager;
import com.caucho.db.store.Lock;
import com.caucho.db.store.StoreTransaction;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Store {
    private static final Logger log = Log.open(Store.class);
    private static final L10N L = new L10N(Store.class);
    public static final int BLOCK_BITS = 16;
    public static final int BLOCK_SIZE = 65536;
    public static final long BLOCK_INDEX_MASK = 65535L;
    public static final long BLOCK_MASK = -65536L;
    public static final long BLOCK_OFFSET_MASK = 65535L;
    private static final int ALLOC_BYTES_PER_BLOCK = 2;
    private static final int ALLOC_CHUNK_SIZE = 2048;
    public static final int ALLOC_FREE = 0;
    public static final int ALLOC_ROW = 1;
    public static final int ALLOC_USED = 2;
    public static final int ALLOC_FRAGMENT = 3;
    public static final int ALLOC_INDEX = 4;
    public static final int ALLOC_MINI_FRAG = 5;
    public static final int ALLOC_MASK = 15;
    public static final int FRAGMENT_SIZE = 8192;
    public static final int FRAGMENT_PER_BLOCK = 8;
    public static final int MINI_FRAG_SIZE = 256;
    public static final int MINI_FRAG_PER_BLOCK = 255;
    public static final int MINI_FRAG_ALLOC_OFFSET = 65280;
    public static final long DATA_START = 65536L;
    public static final int STORE_CREATE_END = 1024;
    protected final Database _database;
    protected final BlockManager _blockManager;
    private final String _name;
    private int _id;
    private Path _path;
    private boolean _isFlushDirtyBlocksOnCommit = true;
    private long _fileSize;
    private long _blockCount;
    private final Object _allocationLock = new Object();
    private byte[] _allocationTable;
    private final Object _allocationWriteLock = new Object();
    private int _allocDirtyMin = Integer.MAX_VALUE;
    private int _allocDirtyMax;
    private final Object _fragmentLock = new Object();
    private final Object _miniFragLock = new Object();
    private final Object _statLock = new Object();
    private long _fragmentUseCount;
    private long _miniFragmentUseCount;
    private Object _fileLock = new Object();
    private SoftReference<RandomAccessWrapper> _cachedRowFile;
    private Lock _rowLock;
    private final Lifecycle _lifecycle = new Lifecycle();

    public Store(Database database, String name, Lock tableLock) {
        this(database, name, tableLock, database.getPath().lookup(name + ".db"));
    }

    public Store(Database database, String name, Lock rowLock, Path path) {
        this._database = database;
        this._blockManager = this._database.getBlockManager();
        this._name = name;
        this._path = path;
        if (path == null) {
            throw new NullPointerException();
        }
        this._id = this._blockManager.allocateStoreId();
        if (rowLock == null) {
            rowLock = new Lock("row-lock:" + this._name + ":" + this._id);
        }
        this._rowLock = rowLock;
    }

    public static Store create(Path path) throws IOException, SQLException {
        Database db = new Database();
        db.init();
        Store store = new Store(db, "temp", null, path);
        if (path.canRead()) {
            store.init();
        } else {
            store.create();
        }
        return store;
    }

    public void setFlushDirtyBlocksOnCommit(boolean flushOnCommit) {
        this._isFlushDirtyBlocksOnCommit = flushOnCommit;
    }

    public boolean isFlushDirtyBlocksOnCommit() {
        return this._isFlushDirtyBlocksOnCommit;
    }

    public String getName() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public Lock getLock() {
        return this._rowLock;
    }

    public BlockManager getBlockManager() {
        return this._blockManager;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public long getBlockCount() {
        return this._blockCount;
    }

    private static long blockIndexToAddr(long blockIndex) {
        return blockIndex << 16;
    }

    private final long blockIndexToBlockId(long blockIndex) {
        return (blockIndex << 16) + (long)this._id;
    }

    private static long blockIdToIndex(long blockId) {
        return blockId >> 16;
    }

    public final long addressToBlockId(long address) {
        return (address & 0xFFFFFFFFFFFF0000L) + (long)this._id;
    }

    public static long blockIdToAddress(long blockId) {
        return blockId & 0xFFFFFFFFFFFF0000L;
    }

    public static long blockIdToAddress(long blockId, int offset) {
        return (blockId & 0xFFFFFFFFFFFF0000L) + (long)offset;
    }

    public long getTotalFragmentSize() {
        return this._fragmentUseCount * 8192L;
    }

    public void create() throws IOException, SQLException {
        if (!this._lifecycle.toActive()) {
            return;
        }
        log.finer(this + " create");
        this._path.getParent().mkdirs();
        if (this._path.exists()) {
            throw new SQLException(L.l("Table '{0}' already exists.  CREATE can not override an existing table.", (Object)this._name));
        }
        this._allocationTable = new byte[2048];
        this.setAllocation(0L, 2);
        this.setAllocation(1L, 2);
        byte[] buffer = new byte[65536];
        this.writeBlock(0L, buffer, 0, 65536);
        this.writeBlock(65536L, buffer, 0, 65536);
        this.writeBlock(0L, this._allocationTable, 0, this._allocationTable.length);
        this._blockCount = 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        if (!this._lifecycle.toActive()) {
            return;
        }
        log.finer(this + " init");
        RandomAccessWrapper wrapper = this.openRowFile();
        try {
            RandomAccessStream file = wrapper.getFile();
            this._fileSize = file.getLength();
            this._blockCount = (this._fileSize + 65536L - 1L) / 65536L;
            int allocCount = (int)(this._blockCount * 2L);
            allocCount += 2048 - allocCount % 2048;
            this._allocationTable = new byte[allocCount];
            for (int i = 0; i < allocCount; i += 65536) {
                int len = allocCount - i;
                if (65536 < len) {
                    len = 65536;
                }
                this.readBlock((long)i / 2L * 65536L, this._allocationTable, i, len);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            wrapper.close();
            throw throwable;
        }
        wrapper.close();
    }

    public void remove() throws SQLException {
        try {
            Path path = this._path;
            this._path = null;
            this.close();
            if (path != null) {
                path.remove();
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    public long firstRow(long blockId) throws IOException {
        return this.firstBlock(blockId, 1);
    }

    public long firstFragment(long blockId) throws IOException {
        return this.firstBlock(blockId, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long firstBlock(long blockId, int type) throws IOException {
        if (blockId <= 65536L) {
            blockId = 65536L;
        }
        Object object = this._allocationLock;
        synchronized (object) {
            for (long blockIndex = blockId >> 16; blockIndex < this._blockCount; ++blockIndex) {
                if (this.getAllocation(blockIndex) != type) continue;
                return this.blockIndexToBlockId(blockIndex);
            }
        }
        return -1L;
    }

    public final Block readBlock(long blockAddress) throws IOException {
        long blockId = this.addressToBlockId(blockAddress);
        Block block = this._blockManager.getBlock(this, blockId);
        try {
            block.read();
            return block;
        }
        catch (IOException e) {
            block.free();
            throw e;
        }
        catch (RuntimeException e) {
            block.free();
            throw e;
        }
    }

    public Block allocateRow() throws IOException {
        return this.allocateBlock(1);
    }

    public boolean isRowBlock(long blockAddress) {
        return this.getAllocation(blockAddress / 65536L) == 1;
    }

    public Block allocateBlock() throws IOException {
        return this.allocateBlock(2);
    }

    private Block allocateFragmentBlock() throws IOException {
        return this.allocateBlock(3);
    }

    private Block allocateMiniFragmentBlock() throws IOException {
        return this.allocateBlock(5);
    }

    public Block allocateIndexBlock() throws IOException {
        return this.allocateBlock(4);
    }

    public boolean isIndexBlock(long blockAddress) {
        return this.getAllocation(blockAddress / 65536L) == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block allocateBlock(int code) throws IOException {
        long blockIndex;
        boolean isFileExtended = false;
        Object object = this._allocationLock;
        synchronized (object) {
            long end = this._blockCount;
            if ((long)this._allocationTable.length < 2L * end) {
                end = this._allocationTable.length / 2;
            }
            for (blockIndex = 0L; blockIndex < end && this.getAllocation(blockIndex) != 0; ++blockIndex) {
            }
            if ((long)this._allocationTable.length <= 2L * blockIndex) {
                byte[] newTable = new byte[this._allocationTable.length + 2048];
                System.arraycopy(this._allocationTable, 0, newTable, 0, this._allocationTable.length);
                this._allocationTable = newTable;
                if (blockIndex % 32768L == 0L) {
                    this.setAllocation(blockIndex, 2);
                    ++blockIndex;
                }
            }
            this.setAllocation(blockIndex, 2);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " allocating block " + blockIndex + " " + Store.codeToName(code));
            }
            if (this._blockCount <= blockIndex) {
                isFileExtended = true;
                this._blockCount = blockIndex + 1L;
            }
        }
        long blockId = this.blockIndexToBlockId(blockIndex);
        Block block = this._blockManager.getBlock(this, blockId);
        byte[] buffer = block.getBuffer();
        for (int i = 65535; i >= 0; --i) {
            buffer[i] = 0;
        }
        block.setDirty(0, 65536);
        if (isFileExtended) {
            try {
                block.write();
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        Object object2 = this._allocationLock;
        synchronized (object2) {
            this.setAllocation(blockIndex, code);
        }
        this.saveAllocation();
        return block;
    }

    protected void validateBlockId(long blockId) throws IllegalArgumentException, IllegalStateException {
        RuntimeException e = null;
        if (this.isClosed()) {
            e = new IllegalStateException(L.l("store {0} is closing.", (Object)this));
        } else if (this.getId() <= 0) {
            e = new IllegalStateException(L.l("invalid store {0}.", (Object)this));
        } else if ((long)this.getId() != (blockId & 0xFFFFL)) {
            e = new IllegalArgumentException(L.l("block {0} must match store {1}.", (Object)(blockId & 0xFFFFL), (Object)this));
        }
        if (e != null) {
            throw e;
        }
    }

    protected void assertStoreActive() throws IllegalStateException {
        IllegalStateException e = null;
        if (this.isClosed()) {
            e = new IllegalStateException(L.l("store {0} is closing.", (Object)this));
        } else if (this.getId() <= 0) {
            e = new IllegalStateException(L.l("invalid store {0}.", (Object)this));
        }
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeBlock(long blockId) throws IOException {
        if (blockId == 0L) {
            return;
        }
        Object object = this._allocationLock;
        synchronized (object) {
            this.setAllocation(Store.blockIdToIndex(blockId), 0);
        }
        this.saveAllocation();
    }

    private final int getAllocation(long blockIndex) {
        int allocOffset = (int)(2L * blockIndex);
        return this._allocationTable[allocOffset] & 0xF;
    }

    private void setAllocation(long blockIndex, int code) {
        int allocOffset = (int)(2L * blockIndex);
        for (int i = 1; i < 2; ++i) {
            this._allocationTable[allocOffset + i] = 0;
        }
        this._allocationTable[allocOffset] = (byte)code;
        this.setAllocDirty(allocOffset, allocOffset + 2);
    }

    private void setAllocDirty(int min, int max) {
        if (min < this._allocDirtyMin) {
            this._allocDirtyMin = min;
        }
        if (this._allocDirtyMax < max) {
            this._allocDirtyMax = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveAllocation() throws IOException {
        if (!this._isFlushDirtyBlocksOnCommit) {
            return;
        }
        Object object = this._allocationWriteLock;
        synchronized (object) {
            int dirtyMax;
            int dirtyMin;
            Object object2 = this._allocationLock;
            synchronized (object2) {
                dirtyMin = this._allocDirtyMin;
                this._allocDirtyMin = Integer.MAX_VALUE;
                dirtyMax = this._allocDirtyMax;
                this._allocDirtyMax = 0;
            }
            while (dirtyMin < dirtyMax) {
                int block = dirtyMin / 32768;
                int offset = dirtyMin % 65536;
                int length = dirtyMin / 65536 != dirtyMax / 65536 ? 65536 - offset : dirtyMax - dirtyMin;
                this.writeBlock((long)block * 65536L + (long)offset, this._allocationTable, offset, length);
                dirtyMin = dirtyMin + 65536 - dirtyMin % 65536;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFragment(long fragmentAddress, int fragmentOffset, byte[] buffer, int offset, int length) throws IOException {
        if (8192 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                System.arraycopy(blockBuffer, blockOffset + fragmentOffset, buffer, offset, length);
                // ** MonitorExit[var10_9] (shouldn't be in output)
                int n = length;
                Object var13_12 = null;
                block.free();
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFragment(long fragmentAddress, int fragmentOffset, char[] buffer, int offset, int length) throws IOException {
        if (8192 - fragmentOffset < 2 * length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            blockOffset += fragmentOffset;
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                for (int i = 0; i < length; ++i) {
                    int ch1 = blockBuffer[blockOffset] & 0xFF;
                    int ch2 = blockBuffer[blockOffset + 1] & 0xFF;
                    buffer[offset + i] = (char)((ch1 << 8) + ch2);
                    blockOffset += 2;
                }
                // ** MonitorExit[var10_9] (shouldn't be in output)
                int n = length;
                Object var16_15 = null;
                block.free();
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long readFragmentLong(long fragmentAddress, int fragmentOffset) throws IOException {
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                long l = Store.readLong(blockBuffer, blockOffset + fragmentOffset);
                // ** MonitorExit[var7_6] (shouldn't be in output)
                Object var12_8 = null;
                block.free();
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBlock(long blockAddress, int blockOffset, byte[] buffer, int offset, int length) throws IOException {
        if (65536 - blockOffset < length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", blockOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(blockAddress));
        try {
            byte[] blockBuffer;
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                System.arraycopy(blockBuffer, blockOffset, buffer, offset, length);
                // ** MonitorExit[var9_8] (shouldn't be in output)
                int n = length;
                Object var12_11 = null;
                block.free();
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBlock(long blockAddress, int blockOffset, char[] buffer, int offset, int length) throws IOException {
        if (65536 - blockOffset < 2 * length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", blockOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(blockAddress));
        try {
            byte[] blockBuffer;
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                for (int i = 0; i < length; ++i) {
                    int ch1 = blockBuffer[blockOffset] & 0xFF;
                    int ch2 = blockBuffer[blockOffset + 1] & 0xFF;
                    buffer[offset + i] = (char)((ch1 << 8) + ch2);
                    blockOffset += 2;
                }
                // ** MonitorExit[var9_8] (shouldn't be in output)
                int n = length;
                Object var15_14 = null;
                block.free();
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long readBlockLong(long blockAddress, int offset) throws IOException {
        Block block = this.readBlock(this.addressToBlockId(blockAddress));
        try {
            byte[] blockBuffer;
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                long l = Store.readLong(blockBuffer, offset);
                // ** MonitorExit[var6_5] (shouldn't be in output)
                Object var11_7 = null;
                block.free();
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateFragment(StoreTransaction xa) throws IOException {
        while (true) {
            Object object = this._allocationLock;
            synchronized (object) {
                byte[] allocationTable = this._allocationTable;
                for (int i = 0; i < allocationTable.length; i += 2) {
                    int fragMask = allocationTable[i + 1] & 0xFF;
                    if (allocationTable[i] != 3 || fragMask == 255) continue;
                    for (int j = 0; j < 8; ++j) {
                        if ((fragMask & 1 << j) != 0) continue;
                        allocationTable[i + 1] = (byte)(fragMask | 1 << j);
                        this.setAllocDirty(i + 1, i + 2);
                        ++this._fragmentUseCount;
                        long fragmentAddress = 65536L * ((long)i / 2L) + (long)j;
                        return fragmentAddress;
                    }
                }
            }
            Block block = this.allocateFragmentBlock();
            block.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFragment(StoreTransaction xa, long fragmentAddress) throws IOException {
        Object object = this._allocationLock;
        synchronized (object) {
            int i = (int)(2L * (fragmentAddress / 65536L));
            int j = (int)(fragmentAddress & 0xFFL);
            int fragMask = this._allocationTable[i + 1] & 0xFF;
            if (this._allocationTable[i] != 3) {
                System.out.println("BAD ENTRY: " + fragMask);
            }
            if (j >= 8) {
                System.out.println("BAD J: " + fragMask);
            }
            if ((fragMask & 1 << j) == 0) {
                log.fine("BAD J-MASK: " + fragMask + " " + j);
            }
            this._allocationTable[i + 1] = (byte)(fragMask & ~(1 << j));
            --this._fragmentUseCount;
            this.setAllocDirty(i + 1, i + 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFragment(StoreTransaction xa, long fragmentAddress, int fragmentOffset, byte[] buffer, int offset, int length) throws IOException {
        if (8192 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            xa.addUpdateFragmentBlock(block);
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] blockBuffer = block.getBuffer();
            blockOffset += fragmentOffset;
            byte[] byArray = blockBuffer;
            synchronized (blockBuffer) {
                System.arraycopy(buffer, offset, blockBuffer, blockOffset, length);
                block.setDirty(blockOffset, blockOffset + length);
                // ** MonitorExit[var11_10] (shouldn't be in output)
                Object var14_12 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFragment(StoreTransaction xa, long fragmentAddress, int fragmentOffset, char[] buffer, int offset, int length) throws IOException {
        if (8192 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            block = xa.createAutoCommitWriteBlock(block);
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] blockBuffer = block.getBuffer();
            blockOffset += fragmentOffset;
            byte[] byArray = blockBuffer;
            synchronized (blockBuffer) {
                int blockTail = blockOffset;
                for (int i = 0; i < length; ++i) {
                    char ch = buffer[offset + i];
                    blockBuffer[blockTail] = (byte)(ch >> 8);
                    blockBuffer[blockTail + 1] = (byte)ch;
                    blockTail += 2;
                }
                block.setDirty(blockOffset, blockTail);
                // ** MonitorExit[var11_10] (shouldn't be in output)
                Object var17_15 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFragmentLong(StoreTransaction xa, long fragmentAddress, int fragmentOffset, long value) throws IOException {
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            xa.addUpdateBlock(block);
            int blockOffset = this.getFragmentOffset(fragmentAddress);
            byte[] blockBuffer = block.getBuffer();
            int offset = blockOffset + fragmentOffset;
            byte[] byArray = blockBuffer;
            synchronized (blockBuffer) {
                Store.writeLong(blockBuffer, offset, value);
                block.setDirty(offset, offset + 8);
                // ** MonitorExit[var11_9] (shouldn't be in output)
                Object var14_11 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlock(StoreTransaction xa, long blockAddress, int blockOffset, byte[] buffer, int offset, int length) throws IOException {
        if (65536 - blockOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", blockOffset, length));
        }
        Block block = xa.readBlock(this, this.addressToBlockId(blockAddress));
        try {
            byte[] blockBuffer;
            xa.addUpdateBlock(block);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                System.arraycopy(buffer, offset, blockBuffer, blockOffset, length);
                block.setDirty(blockOffset, blockOffset + length);
                // ** MonitorExit[var10_9] (shouldn't be in output)
                Object var13_11 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlock(StoreTransaction xa, long blockAddress, int blockOffset, char[] buffer, int offset, int length) throws IOException {
        if (65536 - blockOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", blockOffset, length));
        }
        Block block = xa.readBlock(this, this.addressToBlockId(blockAddress));
        try {
            byte[] blockBuffer;
            block = xa.createAutoCommitWriteBlock(block);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                int blockTail = blockOffset;
                for (int i = 0; i < length; ++i) {
                    char ch = buffer[offset + i];
                    blockBuffer[blockTail] = (byte)(ch >> 8);
                    blockBuffer[blockTail + 1] = (byte)ch;
                    blockTail += 2;
                }
                block.setDirty(blockOffset, blockTail);
                // ** MonitorExit[var10_9] (shouldn't be in output)
                Object var16_14 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlockLong(StoreTransaction xa, long blockAddress, int offset, long value) throws IOException {
        Block block = xa.readBlock(this, this.addressToBlockId(blockAddress));
        try {
            byte[] blockBuffer;
            xa.addUpdateBlock(block);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                Store.writeLong(blockBuffer, offset, value);
                block.setDirty(offset, offset + 8);
                // ** MonitorExit[var9_7] (shouldn't be in output)
                Object var12_9 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            block.free();
            throw throwable;
        }
    }

    private int getFragmentOffset(long fragmentAddress) {
        int id = (int)(fragmentAddress & 0xFFFFL);
        return 8192 * id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readMiniFragment(long fragmentAddress, int fragmentOffset, byte[] buffer, int offset, int length) throws IOException {
        if (256 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                System.arraycopy(blockBuffer, blockOffset + fragmentOffset, buffer, offset, length);
                // ** MonitorExit[var10_9] (shouldn't be in output)
                int n = length;
                Object var13_12 = null;
                block.free();
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readMiniFragment(long fragmentAddress, int fragmentOffset, char[] buffer, int offset, int length) throws IOException {
        if (256 - fragmentOffset < 2 * length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
            blockOffset += fragmentOffset;
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                for (int i = 0; i < length; ++i) {
                    int ch1 = blockBuffer[blockOffset] & 0xFF;
                    int ch2 = blockBuffer[blockOffset + 1] & 0xFF;
                    buffer[offset + i] = (char)((ch1 << 8) + ch2);
                    blockOffset += 2;
                }
                // ** MonitorExit[var10_9] (shouldn't be in output)
                int n = length;
                Object var16_15 = null;
                block.free();
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long readMiniFragmentLong(long fragmentAddress, int fragmentOffset) throws IOException {
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            byte[] blockBuffer;
            int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                long l = Store.readLong(blockBuffer, blockOffset + fragmentOffset);
                // ** MonitorExit[var7_6] (shouldn't be in output)
                Object var12_8 = null;
                block.free();
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public long allocateMiniFragment(StoreTransaction xa) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateMiniFragmentBlock(StoreTransaction xa) throws IOException {
        while (true) {
            Object object = this._allocationLock;
            synchronized (object) {
                byte[] allocationTable = this._allocationTable;
                for (int i = 0; i < allocationTable.length; i += 2) {
                    int fragMask = allocationTable[i + 1] & 0xFF;
                    if (allocationTable[i] != 5 || fragMask == 255) continue;
                    allocationTable[i + 1] = -1;
                    this.setAllocDirty(i + 1, i + 2);
                    ++this._miniFragmentUseCount;
                    long fragmentAddress = 65536L * ((long)i / 2L);
                    return fragmentAddress;
                }
            }
            Block block = this.allocateMiniFragmentBlock();
            block.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMiniFragment(StoreTransaction xa, long fragmentAddress) throws IOException {
        Block block = this.readBlock(fragmentAddress);
        try {
            byte[] blockBuffer;
            int fragIndex = (int)(fragmentAddress & 0xFFFFL);
            int offset = fragIndex / 8 + 65280;
            int mask = 1 << fragIndex % 8;
            byte[] byArray = blockBuffer = block.getBuffer();
            synchronized (blockBuffer) {
                int n = offset;
                blockBuffer[n] = (byte)(blockBuffer[n] & ~mask);
                block.setDirty(offset, offset + 1);
                int i = (int)(2L * (fragmentAddress / 65536L));
                int j = (int)(fragmentAddress & 0xFFL);
                Object object = this._allocationLock;
                synchronized (object) {
                    int fragMask = this._allocationTable[i + 1] & 0xFF;
                    if (this._allocationTable[i] != 5) {
                        System.out.println("BAD ENTRY: " + fragMask);
                    }
                    this._allocationTable[i + 1] = 0;
                    --this._miniFragmentUseCount;
                    this.setAllocDirty(i + 1, i + 2);
                }
                // ** MonitorExit[var9_8] (shouldn't be in output)
                Object var17_15 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMiniFragment(StoreTransaction xa, long fragmentAddress, int fragmentOffset, byte[] buffer, int offset, int length) throws IOException {
        if (256 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            xa.addUpdateBlock(block);
            int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
            byte[] blockBuffer = block.getBuffer();
            blockOffset += fragmentOffset;
            byte[] byArray = blockBuffer;
            synchronized (blockBuffer) {
                System.arraycopy(buffer, offset, blockBuffer, blockOffset, length);
                block.setDirty(blockOffset, blockOffset + length);
                // ** MonitorExit[var11_10] (shouldn't be in output)
                Object var14_12 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMiniFragment(StoreTransaction xa, long fragmentAddress, int fragmentOffset, char[] buffer, int offset, int length) throws IOException {
        if (256 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            block = xa.createAutoCommitWriteBlock(block);
            int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
            byte[] blockBuffer = block.getBuffer();
            blockOffset += fragmentOffset;
            byte[] byArray = blockBuffer;
            synchronized (blockBuffer) {
                int blockTail = blockOffset;
                for (int i = 0; i < length; ++i) {
                    char ch = buffer[offset + i];
                    blockBuffer[blockTail] = (byte)(ch >> 8);
                    blockBuffer[blockTail + 1] = (byte)ch;
                    blockTail += 2;
                }
                block.setDirty(blockOffset, blockTail);
                // ** MonitorExit[var11_10] (shouldn't be in output)
                Object var17_15 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMiniFragmentLong(StoreTransaction xa, long fragmentAddress, int fragmentOffset, long value) throws IOException {
        Block block = xa.readBlock(this, this.addressToBlockId(fragmentAddress));
        try {
            xa.addUpdateBlock(block);
            int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
            byte[] blockBuffer = block.getBuffer();
            int offset = blockOffset + fragmentOffset;
            byte[] byArray = blockBuffer;
            synchronized (blockBuffer) {
                Store.writeLong(blockBuffer, offset, value);
                block.setDirty(offset, offset + 8);
                // ** MonitorExit[var11_9] (shouldn't be in output)
                Object var14_11 = null;
                block.free();
            }
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            block.free();
            throw throwable;
        }
    }

    private int getMiniFragmentOffset(long fragmentAddress) {
        int id = (int)(fragmentAddress & 0xFFFFL);
        return 256 * id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readBlock(long blockId, byte[] buffer, int offset, int length) throws IOException {
        Object object = this._fileLock;
        synchronized (object) {
            RandomAccessWrapper wrapper = this.openRowFile();
            RandomAccessStream is = wrapper.getFile();
            long blockAddress = blockId & 0xFFFFFFFFFFFF0000L;
            try {
                if (blockAddress < 0L) throw new IllegalStateException(L.l("block at {0} is invalid for file {1} (length {2})", (Object)Long.toHexString(blockAddress), (Object)this._path, (Object)Long.toHexString(this._fileSize)));
                if (this._fileSize < blockAddress + (long)length) {
                    throw new IllegalStateException(L.l("block at {0} is invalid for file {1} (length {2})", (Object)Long.toHexString(blockAddress), (Object)this._path, (Object)Long.toHexString(this._fileSize)));
                }
                int readLen = is.read(blockAddress, buffer, offset, length);
                if (readLen < 0) {
                    for (int i = 0; i < 65536; ++i) {
                        buffer[i] = 0;
                    }
                }
                this.freeRowFile(wrapper);
                return;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (wrapper == null) throw throwable;
                wrapper.close();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBlock(long blockAddress, byte[] buffer, int offset, int length) throws IOException {
        Object object = this._fileLock;
        synchronized (object) {
            RandomAccessWrapper wrapper = this.openRowFile();
            RandomAccessStream os = wrapper.getFile();
            try {
                os.write(blockAddress, buffer, offset, length);
                this.freeRowFile(wrapper);
                wrapper = null;
                if (this._fileSize < blockAddress + (long)length) {
                    this._fileSize = blockAddress + (long)length;
                }
                Object var10_8 = null;
                if (wrapper == null) return;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (wrapper == null) throw throwable;
                wrapper.close();
                throw throwable;
            }
            wrapper.close();
            {
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessWrapper openRowFile() throws IOException {
        RandomAccessStream file = null;
        RandomAccessWrapper wrapper = null;
        Store store = this;
        synchronized (store) {
            SoftReference<RandomAccessWrapper> ref = this._cachedRowFile;
            this._cachedRowFile = null;
            if (ref != null) {
                wrapper = ref.get();
            }
        }
        if (wrapper != null) {
            file = wrapper.getFile();
        }
        if (file == null) {
            file = this._path.openRandomAccess();
            wrapper = new RandomAccessWrapper(file);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeRowFile(RandomAccessWrapper wrapper) throws IOException {
        Store store = this;
        synchronized (store) {
            if (this._cachedRowFile == null) {
                this._cachedRowFile = new SoftReference<RandomAccessWrapper>(wrapper);
                return;
            }
        }
        wrapper.close();
    }

    private static void writeShort(byte[] buffer, int offset, int v) {
        buffer[offset + 0] = (byte)(v >> 8);
        buffer[offset + 1] = (byte)v;
    }

    private static int readShort(byte[] buffer, int offset) {
        return (buffer[offset + 0] & 0xFF) << 8 | buffer[offset + 1] & 0xFF;
    }

    public void flush() {
        if (this._lifecycle.isActive() && this._blockManager != null) {
            this._blockManager.flush(this);
        }
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroyed();
    }

    public void close() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        log.finer(this + " closing");
        if (this._blockManager != null) {
            this._blockManager.freeStore(this);
            this._blockManager.freeStoreId(this._id);
        }
        long id = this._id;
        this._id = 0;
        RandomAccessWrapper wrapper = null;
        SoftReference<RandomAccessWrapper> ref = this._cachedRowFile;
        this._cachedRowFile = null;
        if (ref != null) {
            wrapper = ref.get();
        }
        if (wrapper != null) {
            try {
                wrapper.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public byte[] getAllocationTable() {
        byte[] table = new byte[this._allocationTable.length];
        System.arraycopy(this._allocationTable, 0, table, 0, table.length);
        return table;
    }

    private static IllegalStateException stateError(String msg) {
        IllegalStateException e = new IllegalStateException(msg);
        e.fillInStackTrace();
        log.log(Level.WARNING, e.toString(), e);
        return e;
    }

    public static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    public static void writeLong(byte[] buffer, int offset, long v) {
        buffer[offset + 0] = (byte)(v >> 56);
        buffer[offset + 1] = (byte)(v >> 48);
        buffer[offset + 2] = (byte)(v >> 40);
        buffer[offset + 3] = (byte)(v >> 32);
        buffer[offset + 4] = (byte)(v >> 24);
        buffer[offset + 5] = (byte)(v >> 16);
        buffer[offset + 6] = (byte)(v >> 8);
        buffer[offset + 7] = (byte)v;
    }

    public static String codeToName(int code) {
        switch (code) {
            case 0: {
                return "free";
            }
            case 1: {
                return "row";
            }
            case 2: {
                return "used";
            }
            case 3: {
                return "fragment";
            }
            case 5: {
                return "mini-fragment";
            }
            case 4: {
                return "index";
            }
        }
        return String.valueOf(code);
    }

    public String toString() {
        return "Store[" + this._id + "]";
    }

    static class RandomAccessWrapper {
        private RandomAccessStream _file;

        RandomAccessWrapper(RandomAccessStream file) {
            this._file = file;
        }

        RandomAccessStream getFile() {
            return this._file;
        }

        void close() throws IOException {
            RandomAccessStream file = this._file;
            this._file = null;
            if (file != null) {
                file.close();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.close();
        }
    }
}

