/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.db.store.AutoCommitWriteBlock;
import com.caucho.db.store.Block;
import com.caucho.db.store.Inode;
import com.caucho.db.store.Lock;
import com.caucho.db.store.Store;
import com.caucho.db.store.StoreTransaction;
import com.caucho.db.store.WriteBlock;
import com.caucho.db.store.XAWriteBlock;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.util.LongKeyHashMap;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transaction
extends StoreTransaction {
    private static final Logger log = Log.open(Transaction.class);
    private static final L10N L = new L10N(Transaction.class);
    private static long AUTO_COMMIT_TIMEOUT = 30000L;
    private boolean _isAutoCommit = true;
    private ConnectionImpl _conn;
    private ArrayList<Lock> _readLocks;
    private ArrayList<Lock> _writeLocks;
    private LongKeyHashMap<WriteBlock> _writeBlocks;
    private ArrayList<Block> _updateBlocks;
    private ArrayList<Inode> _deleteInodes;
    private ArrayList<Inode> _addInodes;
    private ArrayList<Block> _deallocateBlocks;
    private boolean _isRollbackOnly;
    private SQLException _rollbackExn;
    private long _timeout = AUTO_COMMIT_TIMEOUT;

    private Transaction() {
    }

    public static Transaction create(ConnectionImpl conn) {
        Transaction xa = new Transaction();
        xa.init(conn);
        return xa;
    }

    public static Transaction create() {
        Transaction xa = new Transaction();
        return xa;
    }

    private void init(ConnectionImpl conn) {
        this._conn = conn;
        this._timeout = AUTO_COMMIT_TIMEOUT;
        this._isRollbackOnly = false;
        this._rollbackExn = null;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public boolean hasReadLock(Lock lock) {
        return this._readLocks.contains(lock);
    }

    public boolean isAutoCommit() {
        return this._isAutoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this._isAutoCommit = autoCommit;
    }

    public void lockRead(Lock lock) throws SQLException {
        if (this._isRollbackOnly) {
            if (this._rollbackExn != null) {
                throw this._rollbackExn;
            }
            throw new SQLException(L.l("can't get lock with rollback transaction"));
        }
        try {
            if (this._readLocks == null) {
                this._readLocks = new ArrayList();
            }
            if (this._readLocks.contains(lock)) {
                throw new SQLException(L.l("lockRead must not already have a read lock"));
            }
            lock.lockRead(this, this._timeout);
            this._readLocks.add(lock);
        }
        catch (SQLException e) {
            this.setRollbackOnly(e);
            throw e;
        }
    }

    public void lockReadAndWrite(Lock lock) throws SQLException {
        if (this._isRollbackOnly) {
            if (this._rollbackExn != null) {
                throw this._rollbackExn;
            }
            throw new SQLException(L.l("can't get lock with rollback transaction"));
        }
        try {
            if (this._readLocks == null) {
                this._readLocks = new ArrayList();
            }
            if (this._writeLocks == null) {
                this._writeLocks = new ArrayList();
            }
            if (this._readLocks.contains(lock)) {
                throw new SQLException(L.l("lockReadAndWrite cannot already have a read lock"));
            }
            if (this._writeLocks.contains(lock)) {
                throw new SQLException(L.l("lockReadAndWrite cannot already have a write lock"));
            }
            lock.lockReadAndWrite(this, this._timeout);
            this._readLocks.add(lock);
            this._writeLocks.add(lock);
        }
        catch (SQLException e) {
            this.setRollbackOnly(e);
            throw e;
        }
    }

    public boolean lockReadAndWriteNoWait(Lock lock) throws SQLException {
        if (this._isRollbackOnly) {
            if (this._rollbackExn != null) {
                throw this._rollbackExn;
            }
            throw new SQLException(L.l("can't get lock with rollback transaction"));
        }
        try {
            if (this._readLocks == null) {
                this._readLocks = new ArrayList();
            }
            if (this._writeLocks == null) {
                this._writeLocks = new ArrayList();
            }
            if (this._readLocks.contains(lock)) {
                throw new SQLException(L.l("lockReadAndWrite cannot already have a read lock"));
            }
            if (this._writeLocks.contains(lock)) {
                throw new SQLException(L.l("lockReadAndWrite cannot already have a write lock"));
            }
            if (lock.lockReadAndWriteNoWait()) {
                this._readLocks.add(lock);
                this._writeLocks.add(lock);
                return true;
            }
        }
        catch (SQLException e) {
            this.setRollbackOnly(e);
            throw e;
        }
        return false;
    }

    public void lockWrite(Lock lock) throws SQLException {
        if (this._isRollbackOnly) {
            if (this._rollbackExn != null) {
                throw this._rollbackExn;
            }
            throw new SQLException(L.l("can't get lock with rollback transaction"));
        }
        try {
            if (this._readLocks == null) {
                this._readLocks = new ArrayList();
            }
            if (this._writeLocks == null) {
                this._writeLocks = new ArrayList();
            }
            if (!this._readLocks.contains(lock)) {
                Thread.dumpStack();
                throw new SQLException(L.l("lockWrite must already have a read lock"));
            }
            if (this._writeLocks.contains(lock)) {
                throw new SQLException(L.l("lockWrite cannot already have a write lock"));
            }
            lock.lockWrite(this, this._timeout);
            this._writeLocks.add(lock);
        }
        catch (SQLException e) {
            this.setRollbackOnly(e);
            throw e;
        }
    }

    public void addUpdateBlock(Block block) {
        if (block == null) {
            return;
        }
        if (this._updateBlocks == null) {
            this._updateBlocks = new ArrayList();
        }
        if (this._updateBlocks.size() == 0 || this._updateBlocks.get(this._updateBlocks.size() - 1) != block) {
            this._updateBlocks.add(block);
        }
    }

    public void autoCommitRead(Lock lock) throws SQLException {
        this.unlockRead(lock);
    }

    public void unlockRead(Lock lock) throws SQLException {
        if (this._readLocks.remove(lock)) {
            lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoCommitWrite(Lock lock) throws SQLException {
        this._readLocks.remove(lock);
        if (this._writeLocks.remove(lock)) {
            try {
                this.commit();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                lock.unlockWrite();
                throw throwable;
            }
            lock.unlockWrite();
            {
            }
        }
    }

    public void unlockReadAndWrite(Lock lock) throws SQLException {
        this._readLocks.remove(lock);
        if (this._writeLocks.remove(lock)) {
            lock.unlockReadAndWrite();
        }
    }

    public void unlockWrite(Lock lock) throws SQLException {
        if (this._writeLocks.remove(lock)) {
            lock.unlockWrite();
        }
    }

    public Block readBlock(Store store, long blockAddress) throws IOException {
        long blockId = store.addressToBlockId(blockAddress);
        Block block = this._writeBlocks != null ? (Block)this._writeBlocks.get(blockId) : null;
        if (block != null) {
            block.allocate();
        } else {
            block = store.readBlock(blockId);
        }
        return block;
    }

    public WriteBlock getWriteBlock(long blockId) {
        if (this._writeBlocks == null) {
            return null;
        }
        return (WriteBlock)this._writeBlocks.get(blockId);
    }

    public WriteBlock createWriteBlock(Block block) throws IOException {
        if (block instanceof WriteBlock) {
            return (WriteBlock)block;
        }
        WriteBlock writeBlock = this.getWriteBlock(block.getBlockId());
        if (writeBlock != null) {
            block.free();
            writeBlock.allocate();
            return writeBlock;
        }
        if (this.isAutoCommit()) {
            writeBlock = new AutoCommitWriteBlock(block);
        } else {
            writeBlock = new XAWriteBlock(block);
            this.setBlock(writeBlock);
        }
        return writeBlock;
    }

    public Block createAutoCommitWriteBlock(Block block) throws IOException {
        if (block instanceof WriteBlock) {
            return block;
        }
        WriteBlock writeBlock = this.getWriteBlock(block.getBlockId());
        if (writeBlock != null) {
            block.free();
            writeBlock.allocate();
            return writeBlock;
        }
        writeBlock = new AutoCommitWriteBlock(block);
        return writeBlock;
    }

    public Block allocateRow(Store store) throws IOException {
        return store.allocateRow();
    }

    public void deallocateBlock(Block block) throws IOException {
        if (this.isAutoCommit()) {
            block.getStore().freeBlock(block.getBlockId());
        } else {
            if (this._deallocateBlocks == null) {
                this._deallocateBlocks = new ArrayList();
            }
            this._deallocateBlocks.add(block);
        }
    }

    public Block createWriteBlock(Store store, long blockAddress) throws IOException {
        Block block = this.readBlock(store, blockAddress);
        return this.createWriteBlock(block);
    }

    private void setBlock(WriteBlock block) {
        if (this._writeBlocks == null) {
            this._writeBlocks = new LongKeyHashMap(8);
        }
        this._writeBlocks.put(block.getBlockId(), (Object)block);
    }

    public void addDeleteInode(Inode inode) {
        if (this._deleteInodes == null) {
            this._deleteInodes = new ArrayList();
        }
        this._deleteInodes.add(inode);
    }

    public void addAddInode(Inode inode) {
        if (this._addInodes == null) {
            this._addInodes = new ArrayList();
        }
        this._addInodes.add(inode);
    }

    public void autoCommit() throws SQLException {
        if (this._isAutoCommit) {
            ConnectionImpl conn = this._conn;
            this._conn = null;
            if (conn != null) {
                conn.setTransaction(null);
            }
        }
    }

    public void setRollbackOnly(SQLException e) {
        if (this._rollbackExn == null) {
            this._rollbackExn = e;
        }
        this._isRollbackOnly = true;
        this.releaseLocks();
        this._writeBlocks = null;
    }

    public void setRollbackOnly() {
        this.setRollbackOnly(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        try {
            this.writeData();
            Object var2_1 = null;
            this.releaseLocks();
            this.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseLocks();
            this.close();
            throw throwable;
        }
    }

    public void writeData() throws SQLException {
        Block block;
        LongKeyHashMap<WriteBlock> writeBlocks = this._writeBlocks;
        if (this._deleteInodes != null) {
            while (this._deleteInodes.size() > 0) {
                Inode inode = this._deleteInodes.remove(0);
                inode.remove();
            }
        }
        ArrayList<Block> updateBlocks = this._updateBlocks;
        this._updateBlocks = null;
        if (updateBlocks != null) {
            while (updateBlocks.size() > 0) {
                block = updateBlocks.remove(updateBlocks.size() - 1);
                try {
                    block.commit();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        if (writeBlocks != null) {
            Iterator blockIter = writeBlocks.valueIterator();
            while (blockIter.hasNext()) {
                WriteBlock block2 = (WriteBlock)blockIter.next();
                try {
                    block2.commit();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        if (this._deallocateBlocks != null) {
            while (this._deallocateBlocks.size() > 0) {
                block = this._deallocateBlocks.remove(0);
                try {
                    block.getStore().freeBlock(block.getBlockId());
                }
                catch (IOException e) {
                    throw new SQLExceptionWrapper(e);
                }
            }
        }
    }

    public void rollback() throws SQLException {
        this.releaseLocks();
        this.close();
    }

    private void releaseLocks() {
        Lock lock;
        int i;
        if (this._writeLocks != null) {
            for (i = 0; i < this._writeLocks.size(); ++i) {
                lock = this._writeLocks.get(i);
                if (this._readLocks != null) {
                    this._readLocks.remove(lock);
                }
                try {
                    lock.unlockReadAndWrite();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            this._writeLocks.clear();
        }
        if (this._readLocks != null) {
            for (i = 0; i < this._readLocks.size(); ++i) {
                lock = this._readLocks.get(i);
                try {
                    lock.unlockRead();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            this._readLocks.clear();
        }
    }

    void close() {
        LongKeyHashMap<WriteBlock> writeBlocks = this._writeBlocks;
        this._writeBlocks = null;
        if (writeBlocks != null) {
            Iterator blockIter = writeBlocks.valueIterator();
            while (blockIter.hasNext()) {
                WriteBlock block = (WriteBlock)blockIter.next();
                block.destroy();
            }
        }
        this._isRollbackOnly = false;
        this._rollbackExn = null;
    }
}

