/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Block;
import com.caucho.db.store.WriteBlock;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Logger;

public class XAWriteBlock
extends WriteBlock {
    private static final Logger log = Log.open(XAWriteBlock.class);
    private static final L10N L = new L10N(XAWriteBlock.class);
    private byte[] _buffer = (byte[])_freeBuffers.allocate();

    public XAWriteBlock(Block block) throws IOException {
        super(block);
        if (this._buffer == null) {
            this._buffer = new byte[65536];
        }
        block.read();
        System.arraycopy(block.getBuffer(), 0, this.getBuffer(), 0, 65536);
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public void writeImpl(int offset, int length) throws IOException {
        System.arraycopy(this.getBuffer(), offset, this._block.getBuffer(), offset, length);
        this._block.setDirty(offset, offset + length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeImpl() {
        XAWriteBlock xAWriteBlock = this;
        synchronized (xAWriteBlock) {
            byte[] buffer = this._buffer;
            this._buffer = null;
            if (buffer != null) {
                _freeBuffers.free((Object)buffer);
            }
        }
    }

    public String toString() {
        return "XAWriteBlock[" + this.getStore() + "," + this.getBlockId() / 65536L + "]";
    }
}

