/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.index.BinaryKeyCompare;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class BinaryColumn
extends Column {
    private static final Logger log = Logger.getLogger(BinaryColumn.class.getName());
    private static final L10N L = new L10N(BinaryColumn.class);
    private final int _maxLength;

    BinaryColumn(Row row, String name, int maxLength) {
        super(row, name);
        if (maxLength < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        if (255 < maxLength) {
            throw new IllegalArgumentException("length too big");
        }
        this._maxLength = maxLength;
    }

    public int getTypeCode() {
        return 8;
    }

    public Class getJavaType() {
        return String.class;
    }

    public int getDeclarationSize() {
        return this._maxLength;
    }

    public int getLength() {
        return this._maxLength + 1;
    }

    public KeyCompare getIndexKeyCompare() {
        return new BinaryKeyCompare();
    }

    void setString(Transaction xa, byte[] block, int rowOffset, String str) {
        int offset = rowOffset + this._columnOffset;
        if (str == null) {
            this.setNull(block, rowOffset);
            return;
        }
        int len = str.length();
        int maxOffset = offset + this._maxLength + 1;
        int lenOffset = offset++;
        for (int i = 0; i < len && offset < maxOffset; ++i) {
            char ch = str.charAt(i);
            if (ch < '\u0080') {
                block[offset++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                block[offset++] = (byte)(192 + (ch >> 6 & 0x1F));
                block[offset++] = (byte)(128 + (ch & 0x3F));
                continue;
            }
            block[offset++] = (byte)(224 + (ch >> 12 & 0xF));
            block[offset++] = (byte)(128 + (ch >> 6 & 0x3F));
            block[offset++] = (byte)(128 + (ch & 0x3F));
        }
        block[lenOffset] = (byte)(offset - lenOffset - 1);
        this.setNonNull(block, rowOffset);
    }

    public String getString(byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return null;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        StringBuffer sb = new StringBuffer();
        int offset = startOffset + 1;
        int endOffset = offset + len;
        boolean i = false;
        while (offset < endOffset) {
            int ch2;
            int ch1;
            if ((ch1 = block[offset++] & 0xFF) < 128) {
                sb.append((char)ch1);
                continue;
            }
            if ((ch1 & 0xE0) == 192) {
                ch2 = block[offset++] & 0xFF;
                sb.append((char)((ch1 & 0x1F) << 6) + (ch2 & 0x3F));
                continue;
            }
            ch2 = block[offset++] & 0xFF;
            int ch3 = block[offset++] & 0xFF;
            sb.append((char)((ch1 & 0xF) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F));
        }
        return sb.toString();
    }

    void setExpr(Transaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(null)) {
            this.setNull(block, rowOffset);
        } else {
            this.setString(xa, block, rowOffset, expr.evalString(context));
        }
    }

    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        if (this.isNull(block1, rowOffset1) != this.isNull(block2, rowOffset2)) {
            return false;
        }
        int startOffset1 = rowOffset1 + this._columnOffset;
        int len1 = block1[startOffset1] & 0xFF;
        int startOffset2 = rowOffset2 + this._columnOffset;
        int len2 = block2[startOffset2] & 0xFF;
        if (len1 != len2) {
            return false;
        }
        for (int i = len1; i > 0; --i) {
            if (block1[startOffset1 + i] == block2[startOffset2 + i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(byte[] block, int rowOffset, byte[] buffer, int offset, int length) {
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        if (len != length) {
            return false;
        }
        int blockOffset = startOffset + 1;
        int endOffset = blockOffset + len;
        while (blockOffset < endOffset) {
            if (block[blockOffset++] == buffer[offset++]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(byte[] block, int rowOffset, String value) {
        if (value == null) {
            return this.isNull(block, rowOffset);
        }
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        int strLength = value.length();
        int strOffset = 0;
        int offset = startOffset + 1;
        int endOffset = offset + len;
        while (offset < endOffset && strOffset < strLength) {
            char ch;
            int ch1;
            if ((ch1 = block[offset++] & 0xFF) == (ch = value.charAt(strOffset++))) continue;
            return false;
        }
        return offset == endOffset && strOffset == strLength;
    }

    public void evalToResult(byte[] block, int rowOffset, SelectResult result) {
        if (this.isNull(block, rowOffset)) {
            result.writeNull();
            return;
        }
        result.writeString(this.getString(block, rowOffset));
    }

    int evalToBuffer(byte[] block, int rowOffset, byte[] buffer, int bufferOffset) throws SQLException {
        if (this.isNull(block, rowOffset)) {
            return 0;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = this.getLength();
        System.arraycopy(block, startOffset, buffer, bufferOffset, len);
        return len;
    }

    void setIndex(Transaction xa, byte[] block, int rowOffset, long rowAddr, QueryContext context) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            try {
                index.insert(block, rowOffset + this._columnOffset, this.getLength(), rowAddr, xa, false);
            }
            catch (SQLException e) {
                log.log(Level.FINER, e.toString(), e);
                throw new SQLExceptionWrapper(L.l("StringColumn '{0}.{1}' unique index set failed for {2}\n{3}", (Object)this.getTable().getName(), (Object)this.getName(), (Object)this.getString(block, rowOffset), (Object)e.toString()), e);
            }
        }
    }

    void delete(Transaction xa, byte[] block, int rowOffset) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            index.remove(block, rowOffset + this._columnOffset, this.getLength(), xa);
        }
    }

    public String toString() {
        if (this.getIndex() != null) {
            return "VarBinaryColumn[" + this.getName() + ",index]";
        }
        return "VarBinaryColumn[" + this.getName() + "]";
    }
}

