/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.BlobInputStream;
import com.caucho.db.store.BlobOutputStream;
import com.caucho.db.store.Inode;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;

class BlobColumn
extends Column {
    BlobColumn(Row row, String name) {
        super(row, name);
    }

    public int getTypeCode() {
        return 6;
    }

    public Class getJavaType() {
        return Blob.class;
    }

    public int getDeclarationSize() {
        return 128;
    }

    public int getLength() {
        return 128;
    }

    void setString(Transaction xa, byte[] block, int rowOffset, String str) {
        long length;
        if (!this.isNull(block, rowOffset) && 120L <= (length = Inode.readLong(block, rowOffset + this._columnOffset))) {
            Inode inode = new Inode();
            inode.init(this.getTable(), xa, block, rowOffset + this._columnOffset);
            xa.addDeleteInode(inode);
        }
        if (str == null) {
            this.setNull(block, rowOffset);
            return;
        }
        this.setNonNull(block, rowOffset);
        try {
            BlobOutputStream os = new BlobOutputStream(xa, this.getTable(), block, rowOffset + this._columnOffset);
            int length2 = str.length();
            for (int i = 0; i < length2; ++i) {
                char ch = str.charAt(i);
                if (ch < '\u0080') {
                    os.write(ch);
                    continue;
                }
                if (ch < '\u0800') {
                    os.write(192 + (ch >> 6));
                    os.write(128 + (ch & 0x3F));
                    continue;
                }
                os.write(224 + (ch >> 12));
                os.write(128 + (ch >> 6 & 0x3F));
                os.write(128 + (ch & 0x3F));
            }
            os.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private void setStream(Transaction xa, byte[] block, int rowOffset, InputStream value) {
        long length;
        if (!this.isNull(block, rowOffset) && 120L <= (length = Inode.readLong(block, rowOffset + this._columnOffset))) {
            Inode inode = new Inode();
            inode.init(this.getTable(), xa, block, rowOffset + this._columnOffset);
            xa.addDeleteInode(inode);
        }
        if (value == null) {
            this.setNull(block, rowOffset);
            return;
        }
        this.setNonNull(block, rowOffset);
        try {
            int data;
            BlobOutputStream os = new BlobOutputStream(xa, this.getTable(), block, rowOffset + this._columnOffset);
            while ((data = value.read()) >= 0) {
                os.write(data);
            }
            os.close();
            value.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    void delete(Transaction xa, byte[] block, int rowOffset) throws SQLException {
        if (!this.isNull(block, rowOffset)) {
            long length = Inode.readLong(block, rowOffset + this._columnOffset);
            if (length < 120L) {
                return;
            }
            Inode inode = new Inode();
            inode.init(this.getTable(), xa, block, rowOffset + this._columnOffset);
            xa.addDeleteInode(inode);
        }
    }

    public String getString(byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return null;
        }
        try {
            int ch;
            BlobInputStream is = new BlobInputStream(this.getTable(), block, rowOffset + this._columnOffset);
            StringBuilder cb = new StringBuilder();
            while ((ch = is.read()) >= 0) {
                int ch1;
                if (ch < 128) {
                    cb.append((char)ch);
                    continue;
                }
                if ((ch & 0xE0) == 192) {
                    ch1 = is.read();
                    cb.append((char)(((ch & 0x3F) << 6) + (ch1 & 0x3F)));
                    continue;
                }
                ch1 = is.read();
                int ch2 = is.read();
                cb.append((char)(((ch & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch2 & 0x3F)));
            }
            is.close();
            return cb.toString();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public void set(Transaction xa, TableIterator iter, Expr expr, QueryContext context) throws SQLException {
        byte[] block = iter.getBuffer();
        int rowOffset = iter.getRowOffset();
        if (expr.isNull(null)) {
            this.setNull(block, rowOffset);
        } else if (expr.isBinaryStream()) {
            this.setStream(xa, block, rowOffset, expr.evalStream(context));
        } else {
            this.setString(xa, block, rowOffset, expr.evalString(context));
        }
        iter.setDirty();
    }

    void setExpr(Transaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(null)) {
            this.setNull(block, rowOffset);
        } else if (expr.isBinaryStream()) {
            this.setStream(xa, block, rowOffset, expr.evalStream(context));
        } else {
            this.setString(xa, block, rowOffset, expr.evalString(context));
        }
    }

    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        if (this.isNull(block1, rowOffset1) != this.isNull(block2, rowOffset2)) {
            return false;
        }
        int startOffset1 = rowOffset1 + this._columnOffset;
        int startOffset2 = rowOffset2 + this._columnOffset;
        for (int i = 127; i >= 0; --i) {
            if (block1[startOffset1 + i] == block2[startOffset2 + i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(byte[] block, int rowOffset, byte[] buffer, int offset, int length) {
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        return false;
    }

    public boolean isEqual(byte[] block, int rowOffset, String value) {
        if (value == null) {
            return this.isNull(block, rowOffset);
        }
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        return false;
    }

    public void evalToResult(byte[] block, int rowOffset, SelectResult result) {
        if (this.isNull(block, rowOffset)) {
            result.writeNull();
            return;
        }
        result.writeBlob(block, rowOffset + this._columnOffset);
    }

    public String toString() {
        return "BlobColumn[" + this.getName() + "]";
    }
}

