/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableIterator;
import java.sql.SQLException;

class ShortColumn
extends Column {
    ShortColumn(Row row, String name) {
        super(row, name);
    }

    public int getTypeCode() {
        return 9;
    }

    public Class getJavaType() {
        return Short.TYPE;
    }

    public int getDeclarationSize() {
        return 2;
    }

    public int getLength() {
        return 2;
    }

    public KeyCompare getIndexKeyCompare() {
        return null;
    }

    public String getString(byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return null;
        }
        return String.valueOf(this.getInteger(block, rowOffset));
    }

    void setString(Transaction xa, byte[] block, int rowOffset, String str) {
        if (str == null) {
            this.setNull(block, rowOffset);
        } else {
            this.setInteger(xa, block, rowOffset, (int)Long.parseLong(str));
        }
    }

    public int getInteger(byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return 0;
        }
        int offset = rowOffset + this._columnOffset;
        int value = 0;
        value = (block[offset++] & 0xFF) << 8;
        return (short)(value |= block[offset++] & 0xFF);
    }

    void setInteger(Transaction xa, byte[] block, int rowOffset, int value) {
        int offset = rowOffset + this._columnOffset;
        block[offset++] = (byte)(value >> 8);
        block[offset++] = (byte)value;
        this.setNonNull(block, rowOffset);
    }

    void setLong(Transaction xa, byte[] block, int rowOffset, long value) {
        this.setInteger(xa, block, rowOffset, (int)value);
    }

    public long getLong(byte[] block, int rowOffset) {
        return this.getInteger(block, rowOffset);
    }

    void setExpr(Transaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(null)) {
            this.setNull(block, rowOffset);
        } else {
            this.setInteger(xa, block, rowOffset, (int)expr.evalLong(context));
        }
    }

    public void evalToResult(byte[] block, int rowOffset, SelectResult result) {
        if (this.isNull(block, rowOffset)) {
            result.writeNull();
            return;
        }
        int startOffset = rowOffset + this._columnOffset;
        result.write(9);
        result.write(block, startOffset, 2);
    }

    int evalToBuffer(byte[] block, int rowOffset, byte[] buffer, int bufferOffset) throws SQLException {
        if (this.isNull(block, rowOffset)) {
            return 0;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = 2;
        System.arraycopy(block, startOffset, buffer, bufferOffset, len);
        return len;
    }

    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        if (this.isNull(block1, rowOffset1) != this.isNull(block2, rowOffset2)) {
            return false;
        }
        int startOffset1 = rowOffset1 + this._columnOffset;
        int startOffset2 = rowOffset2 + this._columnOffset;
        return block1[startOffset1 + 0] == block2[startOffset2 + 0] && block1[startOffset1 + 1] == block2[startOffset2 + 1];
    }

    void setIndex(Transaction xa, byte[] block, int rowOffset, long rowAddr, QueryContext context) throws SQLException {
        BTree index = this.getIndex();
        if (index == null) {
            return;
        }
        index.insert(block, rowOffset + this._columnOffset, 2, rowAddr, xa, false);
    }

    public void set(TableIterator iter, Expr expr, QueryContext context) throws SQLException {
        iter.setDirty();
        this.setInteger(iter.getTransaction(), iter.getBuffer(), iter.getRowOffset(), (int)expr.evalLong(context));
    }

    void delete(Transaction xa, byte[] block, int rowOffset) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            index.remove(block, rowOffset + this._columnOffset, 2, xa);
        }
    }
}

